/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.ConfigureColumns;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public final class TableViewerFactory {
    public static TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 68354);
        TableViewerFactory.initViewer(viewer);
        return viewer;
    }

    public static TableViewer createVirtualTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 268503810);
        TableViewerFactory.initViewer(viewer);
        return viewer;
    }

    private static void initViewer(TableViewer viewer) {
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        viewer.getTable().setLayoutData((Object)new GridData(1808));
    }

    public static TableViewerColumn createColumn(String header, TableViewer viewer, int width, TableColumnLayout layout, int weight, int alignment) {
        TableViewerColumn column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(header);
        column.getColumn().setToolTipText(header);
        column.getColumn().setMoveable(true);
        column.getColumn().setAlignment(alignment);
        column.getColumn().setResizable(true);
        column.getColumn().setWidth(width);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight));
        return column;
    }

    public static TableColumnLayout createTableColumnLayout(Composite comp) {
        TableColumnLayout layout = new TableColumnLayout();
        comp.setLayoutData((Object)new GridData(1808));
        comp.setLayout((Layout)layout);
        return layout;
    }

    public static Composite createWrapperComposite(Composite parent) {
        Composite newComp = new Composite(parent, 0);
        newComp.setLayout((Layout)new GridLayout());
        newComp.setLayoutData((Object)new GridData(1808));
        return newComp;
    }

    public static void addMenu(final TableViewer v) {
        MenuManager mgr = new MenuManager();
        final Action configureColumns = new Action("Configure Columns..."){

            public void run() {
                ConfigureColumns.forTable((Table)v.getTable(), (IShellProvider)new SameShellProvider(v.getControl()));
            }
        };
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)configureColumns);
            }
        });
        v.getControl().setMenu(mgr.createContextMenu(v.getControl()));
    }

    private TableViewerFactory() {
    }
}

