/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.views;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.recommenders.stats.rcp.model.TriggeredCommandObject;
import org.eclipse.recommenders.stats.rcp.ui.data.CommandData;
import org.eclipse.recommenders.stats.rcp.ui.data.WorkbenchData;
import org.eclipse.recommenders.stats.rcp.ui.util.CommandsUtil;
import org.eclipse.recommenders.stats.rcp.ui.util.EclipseCategoryData;
import org.eclipse.recommenders.stats.rcp.ui.util.LabelHelperFactory;
import org.eclipse.recommenders.stats.rcp.ui.util.TableViewerFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EclipseCategoryView
implements IPageContent {
    private final IDataPersistenceService persistenceService;
    private final Collection<TriggeredCommandObject> commandData;
    private final Map<Long, Long> workbenchData;
    private Composite parent;

    @Inject
    public EclipseCategoryView(IDataPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
        this.commandData = CommandData.create(persistenceService).getData();
        this.workbenchData = WorkbenchData.create(persistenceService).getRawData();
    }

    @Override
    public Composite createContent(Composite detailParent) {
        this.createComposite(detailParent);
        this.createOverviewSection();
        this.createCommandSection();
        this.createActivitySection();
        return this.parent;
    }

    private void createComposite(Composite detailParent) {
        this.parent = TableViewerFactory.createWrapperComposite(detailParent);
        GridLayout grid = new GridLayout(2, false);
        grid.marginHeight = 5;
        grid.horizontalSpacing = 0;
        grid.verticalSpacing = 0;
        this.parent.setLayout((Layout)grid);
    }

    private void createOverviewSection() {
        LabelHelperFactory.createSeparatorLabel(this.parent);
        this.createFilledLabel(this.parent, "Overview about commands usage");
        new Label(this.parent, 0).setText("Number of times commands triggered: ");
        LabelHelperFactory.createLabelWithColor(this.parent, String.valueOf(CommandsUtil.getTriggeredCommandsSize(this.commandData)));
        new Label(this.parent, 0).setText("Beginning of activity tracing: ");
        LabelHelperFactory.createLabelWithColor(this.parent, CommandsUtil.getDescriptionText(this.persistenceService));
    }

    private void createCommandSection() {
        LabelHelperFactory.createSeparatorLabel(this.parent);
        List<TriggeredCommandObject> commandList = EclipseCategoryData.getFavouriteCommands(this.commandData);
        if (commandList.isEmpty()) {
            this.createFilledLabel(this.parent, "Currently no commands tracked.");
        } else {
            this.createFilledLabel(this.parent, "Your favourite commands in this IDE");
            new Label(this.parent, 0).setText("Command #1: ");
            LabelHelperFactory.createLabelWithColor(this.parent, CommandsUtil.getCommandName(commandList.get(0)));
            new Label(this.parent, 0).setText("Command #2: ");
            LabelHelperFactory.createLabelWithColor(this.parent, CommandsUtil.getCommandName(commandList.get(1)));
            new Label(this.parent, 0).setText("Command #3: ");
            LabelHelperFactory.createLabelWithColor(this.parent, CommandsUtil.getCommandName(commandList.get(2)));
        }
    }

    private void createActivitySection() {
        LabelHelperFactory.createSeparatorLabel(this.parent);
        this.createFilledLabel(this.parent, "Number of hours spent in Eclipse");
        new Label(this.parent, 0).setText("Total number of hours: ");
        LabelHelperFactory.createLabelWithColor(this.parent, String.valueOf(EclipseCategoryData.getTotalNumberHours(this.workbenchData)) + " hours");
        new Label(this.parent, 0).setText("Min. number of hours: ");
        LabelHelperFactory.createLabelWithColor(this.parent, String.valueOf(EclipseCategoryData.getMinHoursPerDay(this.workbenchData)) + " hours");
        new Label(this.parent, 0).setText("Max. number of hours: ");
        LabelHelperFactory.createLabelWithColor(this.parent, String.valueOf(EclipseCategoryData.getMaxHoursPerDay(this.workbenchData)) + " hours");
    }

    private void createFilledLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        label.setText(text);
    }
}

