/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.views;

import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.recommenders.stats.rcp.interfaces.ICategoryChildItem;
import org.eclipse.recommenders.stats.rcp.interfaces.ICategoryItem;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.recommenders.stats.rcp.model.TreeCategory;
import org.eclipse.recommenders.stats.rcp.model.TreeItem;
import org.eclipse.recommenders.stats.rcp.ui.ExtensionPointReader;
import org.eclipse.recommenders.stats.rcp.ui.util.LabelHelperFactory;
import org.eclipse.recommenders.stats.rcp.ui.util.TreeViewerSorter;
import org.eclipse.recommenders.stats.rcp.ui.views.CategoryView;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Section;

public class NavigationViewer {
    private TreeViewer viewer;
    private Composite parent;

    public NavigationViewer(Composite detailCmp) {
        this.parent = detailCmp;
    }

    public void createViewer() {
        this.viewer = new TreeViewer(this.parent, 67586);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.getTree().setLinesVisible(false);
        this.viewer.getTree().setHeaderVisible(false);
        this.viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeViewerLabelProvider());
        this.viewer.setSorter((ViewerSorter)new TreeViewerSorter());
        List<ICategoryItem> modelList = ExtensionPointReader.getInstance().createTreeObjectsFromExtensions();
        this.viewer.setInput(modelList);
        this.viewer.expandAll();
        this.viewer.setSelection((ISelection)new StructuredSelection(this.viewer.getExpandedElements()[0]));
        this.viewer.getControl().setFocus();
        LabelHelperFactory.createSeparatorLabel(this.parent);
    }

    public void addSelectionChangedListener(final StackLayout stack, final Composite detailCmp, final Section detailSection) {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (selection instanceof IStructuredSelection && selection instanceof TreeSelection) {
                    TreeSelection treeSelection = (TreeSelection)selection;
                    stack.topControl = NavigationViewer.this.getCompositeFromTreeItems(treeSelection.getFirstElement(), detailCmp, detailSection);
                    detailCmp.layout();
                }
            }
        });
    }

    private Composite getCompositeFromTreeItems(Object selection, Composite detailCmp, Section detailSection) {
        if (selection instanceof TreeCategory) {
            String description = ((TreeCategory)selection).getDescription();
            detailSection.setText(((TreeCategory)selection).getName());
            IPageContent pageObject = ((TreeCategory)selection).getPageObject();
            if (pageObject == null) {
                detailSection.setDescription("");
                return new CategoryView(description).createContent(detailCmp);
            }
            detailSection.setDescription(description);
            return pageObject.createContent(detailCmp);
        }
        if (selection instanceof TreeItem) {
            detailSection.setText(((TreeItem)selection).getName());
            detailSection.setDescription(((TreeItem)selection).getDescription());
            IPageContent pageObject = ((TreeItem)selection).getPageObject();
            return pageObject.createContent(detailCmp);
        }
        return new Composite(detailCmp, 0);
    }

    public class TreeContentProvider
    implements ITreeContentProvider {
        private List<ICategoryItem> catList;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.catList = (List)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.catList.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ICategoryItem) {
                ICategoryItem cat = (ICategoryItem)parentElement;
                return cat.getItems().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ICategoryItem;
        }
    }

    public class TreeViewerLabelProvider
    extends StyledCellLabelProvider {
        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof ICategoryItem) {
                ICategoryItem category = (ICategoryItem)cell.getElement();
                cell.setImage(category.getIcon());
            } else if (cell.getElement() instanceof ICategoryChildItem) {
                ICategoryChildItem item = (ICategoryChildItem)cell.getElement();
                cell.setImage(item.getIcon());
            }
            cell.setText(cell.getElement().toString());
        }
    }
}

