/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.views;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.recommenders.rcp.utils.TableSortConfigurator;
import org.eclipse.recommenders.stats.rcp.events.CompletionEvent;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.recommenders.stats.rcp.ui.data.StatisticData;
import org.eclipse.recommenders.stats.rcp.ui.util.LabelHelperFactory;
import org.eclipse.recommenders.stats.rcp.ui.util.TableSorters;
import org.eclipse.recommenders.stats.rcp.ui.util.TableViewerFactory;
import org.eclipse.recommenders.utils.Bags;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.Names;
import org.eclipse.swt.widgets.Composite;

public class ReceiverTypeView
implements IPageContent {
    private final Collection<CompletionEvent> okayEvents;

    @Inject
    public ReceiverTypeView(IDataPersistenceService persistenceService) {
        this.okayEvents = StatisticData.create(persistenceService).getOkayEvents();
    }

    @Override
    public Composite createContent(Composite detailParent) {
        HashMultiset b = HashMultiset.create();
        for (CompletionEvent e : this.okayEvents) {
            if (e.receiverType == null) continue;
            b.add((Object)e.receiverType);
        }
        List input = Bags.topUsingCount((Multiset)b, (int)30);
        Composite newComp = TableViewerFactory.createWrapperComposite(detailParent);
        LabelHelperFactory.createSeparatorLabel(newComp);
        LabelHelperFactory.createLabelWithColor(newComp, "Total number of triggered receiver types: ", Integer.toString(this.getSize(input)));
        Composite comp = new Composite(newComp, 0);
        TableColumnLayout layout = TableViewerFactory.createTableColumnLayout(comp);
        final TableViewer viewer = TableViewerFactory.createTableViewer(comp);
        TableViewerColumn typeColumn = TableViewerFactory.createColumn("Type", viewer, 450, layout, 60, 16384);
        TableViewerColumn countColumn = TableViewerFactory.createColumn("Count", viewer, 100, layout, 30, 131072);
        TableSortConfigurator.newConfigurator((TableViewer)viewer, (IAction)new Action(){

            public void run() {
                viewer.refresh();
            }
        }).add(typeColumn.getColumn(), TableSorters.ReceiverType.TYPE_COMPARATOR).add(countColumn.getColumn(), TableSorters.ReceiverType.COUNT_COMPARATOR).initialize(countColumn.getColumn(), 1024).configure();
        TableViewerFactory.addMenu(viewer);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new TypeNameLabelProvider());
        viewer.setInput((Object)input);
        LabelHelperFactory.createCounter(newComp, input.size());
        return newComp;
    }

    private int getSize(List<Multiset.Entry<ITypeName>> input) {
        int result = 0;
        for (Multiset.Entry<ITypeName> entry : input) {
            result += entry.getCount();
        }
        return result;
    }

    public class TypeNameLabelProvider
    extends StyledCellLabelProvider {
        public void update(ViewerCell cell) {
            StyledString cellText = new StyledString();
            Multiset.Entry e = (Multiset.Entry)Checks.cast((Object)cell.getElement());
            switch (cell.getColumnIndex()) {
                case 0: {
                    cellText.append(Names.vm2srcQualifiedType((ITypeName)((ITypeName)e.getElement())));
                    break;
                }
                case 1: {
                    cellText.append(Integer.toString(e.getCount()), StyledString.COUNTER_STYLER);
                }
            }
            cell.setText(cellText.toString());
            cell.setStyleRanges(cellText.getStyleRanges());
        }
    }
}

