/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.views;

import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.recommenders.rcp.utils.TableSortConfigurator;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.recommenders.stats.rcp.model.TriggeredCommandObject;
import org.eclipse.recommenders.stats.rcp.ui.data.CommandData;
import org.eclipse.recommenders.stats.rcp.ui.util.CommandsUtil;
import org.eclipse.recommenders.stats.rcp.ui.util.LabelHelperFactory;
import org.eclipse.recommenders.stats.rcp.ui.util.TableSorters;
import org.eclipse.recommenders.stats.rcp.ui.util.TableViewerFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TriggeredCommandsView
implements IPageContent {
    private Composite parent;
    private final IDataPersistenceService persistenceService;

    @Inject
    public TriggeredCommandsView(IDataPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public Composite createContent(Composite detailCmp) {
        this.parent = TableViewerFactory.createWrapperComposite(detailCmp);
        LabelHelperFactory.createSeparatorLabel(this.parent);
        Collection<TriggeredCommandObject> model = CommandData.create(this.persistenceService).getData();
        LabelHelperFactory.createLabelWithColor(this.parent, "Number of times commands triggered: ", Integer.toString(CommandsUtil.getTriggeredCommandsSize(model)));
        Composite comp = new Composite(this.parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        TableColumnLayout layout = TableViewerFactory.createTableColumnLayout(comp);
        final TableViewer viewer = TableViewerFactory.createTableViewer(comp);
        TableViewerColumn commandNameColumn = TableViewerFactory.createColumn("Command Name", viewer, 120, layout, 20, 16384);
        TableViewerColumn countColumn = TableViewerFactory.createColumn("Count", viewer, 80, layout, 8, 131072);
        TableViewerColumn commandIdColumn = TableViewerFactory.createColumn("Command ID", viewer, 130, layout, 40, 16384);
        commandIdColumn.getColumn().setWidth(0);
        TableViewerFactory.createColumn("Description", viewer, 130, layout, 40, 16384);
        Action refreshUiAction = new Action(){

            public void run() {
                viewer.refresh();
            }
        };
        CommandsLabelProvider labelProvider = new CommandsLabelProvider();
        TableSortConfigurator.newConfigurator((TableViewer)viewer, (IAction)refreshUiAction).add(commandNameColumn.getColumn(), TableSorters.Commands.getNameComparator(labelProvider)).add(countColumn.getColumn(), TableSorters.Commands.COUNT_COMPARATOR).add(commandIdColumn.getColumn(), TableSorters.Commands.ID_COMPARATOR).initialize(countColumn.getColumn(), 1024).configure();
        TableViewerFactory.addMenu(viewer);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setInput(model);
        LabelHelperFactory.createCounter(this.parent, model.size());
        return this.parent;
    }

    public class CommandsLabelProvider
    extends StyledCellLabelProvider {
        public void update(ViewerCell cell) {
            if (this.isNotValidCommandObject(cell)) {
                return;
            }
            StyledString cellText = new StyledString();
            TriggeredCommandObject command = (TriggeredCommandObject)cell.getElement();
            switch (cell.getColumnIndex()) {
                case 0: {
                    cellText.append(CommandsUtil.getCommandName(command));
                    break;
                }
                case 1: {
                    cellText.append(Integer.toString(command.count), StyledString.COUNTER_STYLER);
                    break;
                }
                case 2: {
                    cellText.append(command.commandID);
                    break;
                }
                case 3: {
                    cellText.append(CommandsUtil.getCommandDescription(command));
                }
            }
            cell.setText(cellText.toString());
            cell.setStyleRanges(cellText.getStyleRanges());
        }

        private boolean isNotValidCommandObject(ViewerCell cell) {
            return !(cell.getElement() instanceof TriggeredCommandObject);
        }
    }
}

