/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.views;

import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.recommenders.rcp.utils.TableSortConfigurator;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.recommenders.stats.rcp.model.WorkspaceContentType;
import org.eclipse.recommenders.stats.rcp.ui.data.WorkspaceFileData;
import org.eclipse.recommenders.stats.rcp.ui.util.LabelHelperFactory;
import org.eclipse.recommenders.stats.rcp.ui.util.TableSorters;
import org.eclipse.recommenders.stats.rcp.ui.util.TableViewerFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WorkspaceView
implements IPageContent {
    private Label numberOfFilesDesc;
    private Label numberOfFileSizeDesc;
    private Label fileSizeCounter;
    private Label fileNumberCounter;
    private TableViewer viewer;
    private Label counterLabel;

    @Override
    public Composite createContent(Composite detailParent) {
        Composite parent = TableViewerFactory.createWrapperComposite(detailParent);
        Composite labelCmp = this.createWrapper(parent);
        LabelHelperFactory.createTwoSeparatorLabel(labelCmp);
        this.numberOfFilesDesc = new Label(labelCmp, 0);
        this.numberOfFilesDesc.setText("Loading Data from Workspace, please wait ...");
        this.fileNumberCounter = LabelHelperFactory.createLabelWithColor(labelCmp);
        this.numberOfFileSizeDesc = new Label(labelCmp, 0);
        this.numberOfFileSizeDesc.setText("");
        this.fileSizeCounter = LabelHelperFactory.createLabelWithColor(labelCmp);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        TableColumnLayout layout = TableViewerFactory.createTableColumnLayout(comp);
        this.viewer = TableViewerFactory.createVirtualTableViewer(comp);
        TableViewerColumn typeColumn = TableViewerFactory.createColumn("File Type", this.viewer, 60, layout, 10, 0x1000000);
        TableViewerColumn countColumn = TableViewerFactory.createColumn("Count", this.viewer, 60, layout, 10, 0x1000000);
        TableViewerColumn sizeColumn = TableViewerFactory.createColumn("Size", this.viewer, 60, layout, 10, 0x1000000);
        TableSortConfigurator.newConfigurator((TableViewer)this.viewer, (IAction)new Action(){

            public void run() {
                WorkspaceView.this.viewer.refresh();
            }
        }).add(typeColumn.getColumn(), TableSorters.WorkspaceFiles.TYPE_COMPARATOR).add(countColumn.getColumn(), TableSorters.WorkspaceFiles.COUNT_COMPARATOR).add(sizeColumn.getColumn(), TableSorters.WorkspaceFiles.SIZE_COMPARATOR).initialize(sizeColumn.getColumn(), 1024).configure();
        TableViewerFactory.addMenu(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkspaceFileLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.counterLabel = LabelHelperFactory.createCounter(parent, 0);
        this.startFileCollectorJob();
        return parent;
    }

    private void startFileCollectorJob() {
        Job findFilesJob = new Job("Collect all Files"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Collect Files from Workspace", -1);
                WorkspaceFileData workspaceData = new WorkspaceFileData();
                List<WorkspaceContentType> preparedData = workspaceData.getPreparedData();
                this.updateUI(workspaceData, preparedData);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            private void updateUI(final WorkspaceFileData workspaceData, final List<WorkspaceContentType> preparedData) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkspaceView.this.numberOfFilesDesc.setText("Total Number of all Files: ");
                        WorkspaceView.this.numberOfFileSizeDesc.setText("File Size of these Files: ");
                        String fileSize = FileUtils.byteCountToDisplaySize((long)workspaceData.getTotalSize());
                        WorkspaceView.this.fileNumberCounter.setText(Integer.toString(workspaceData.getTotalFiles()));
                        WorkspaceView.this.fileSizeCounter.setText(fileSize);
                        WorkspaceView.this.numberOfFilesDesc.getParent().pack();
                        WorkspaceView.this.viewer.setInput((Object)preparedData);
                        LabelHelperFactory.update(WorkspaceView.this.counterLabel, preparedData.size());
                    }
                });
            }
        };
        findFilesJob.setPriority(20);
        findFilesJob.schedule();
    }

    private Composite createWrapper(Composite parent) {
        Composite labelCmp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        labelCmp.setLayout((Layout)layout);
        labelCmp.setLayoutData((Object)new GridData(768));
        return labelCmp;
    }

    private class WorkspaceFileLabelProvider
    extends StyledCellLabelProvider {
        private WorkspaceFileLabelProvider() {
        }

        public void update(ViewerCell cell) {
            StyledString cellText = new StyledString();
            WorkspaceContentType workspaceFile = (WorkspaceContentType)cell.getElement();
            switch (cell.getColumnIndex()) {
                case 0: {
                    cellText.append(workspaceFile.getLabel());
                    break;
                }
                case 1: {
                    cellText.append(workspaceFile.getCount(), StyledString.COUNTER_STYLER);
                    break;
                }
                case 2: {
                    cellText.append(FileUtils.byteCountToDisplaySize((long)workspaceFile.getBytes()));
                }
            }
            cell.setText(cellText.toString());
            cell.setStyleRanges(cellText.getStyleRanges());
        }
    }
}

