/**
 * Copyright (c) 2013 Timur Achmetow.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Timur Achmetow - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.events;

import javax.annotation.PreDestroy;

import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.model.WorkbenchSession;
import org.eclipse.recommenders.stats.rcp.persistence.Constants;
import org.eclipse.ui.IStartup;

import com.google.inject.Inject;

public class EclipseWorkbenchCollector implements IRcpService, IStartup {

    private long sessionStarted;
    private final IDataPersistenceService service;

    @Inject
    public EclipseWorkbenchCollector(IDataPersistenceService service) {
        this.service = service;
    }

    @PreDestroy
    public void shutDown() {
        WorkbenchSession event = new WorkbenchSession(sessionStarted, System.currentTimeMillis());
        service.record(event, Constants.WORKBENCH_EVENTS_CHANNEL);
    }

    @Override
    public void earlyStartup() {
        sessionStarted = System.currentTimeMillis();
    }
}
