/**
 * Copyright (c) 2013 Timur Achmetow.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Timur Achmetow - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.interfaces;

import java.util.List;

import org.eclipse.swt.graphics.Image;

public interface ICategoryItem {

    /**
     * @return the category name.
     */
    String getName();

    /**
     * @return image for the category.
     */
    Image getIcon();

    /**
     * List with all child items.
     */
    List<ICategoryChildItem> getItems();

    /**
     * Add a new category.
     */
    void addItem(ICategoryChildItem item);
}
