/**
 * Copyright (c) 2015 Akif Etkue.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Akif Etkue - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.model;

public class WorkspaceContentType {

    private final String type;
    private final String count;
    private final long size;

    public WorkspaceContentType(String type, int count, long size) {
        this.type = type.toUpperCase();
        this.count = Integer.toString(count);
        this.size = size;
    }

    public String getLabel() {
        return type;
    }

    public String getCount() {
        return count;
    }

    public long getBytes() {
        return size;
    }
}
