/**
 * Copyright (c) 2013 Timur Achmetow.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Timur Achmetow - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.ui.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.model.TriggeredCommandObject;
import org.eclipse.recommenders.stats.rcp.persistence.Constants;

import com.google.common.annotations.VisibleForTesting;

public final class CommandData {

    private final IDataPersistenceService service;

    private CommandData(IDataPersistenceService service) {
        this.service = service;
    }

    public static CommandData create(IDataPersistenceService service) {
        return new CommandData(service);
    }

    public Collection<TriggeredCommandObject> getData() {
        return buildViewerModel(service.retrieve(TriggeredCommandObject.class, Constants.TRIGGERED_COMMANDS_CHANNEL));
    }

    @VisibleForTesting
    protected static Collection<TriggeredCommandObject> buildViewerModel(Collection<TriggeredCommandObject> commandList) {
        final Map<String, TriggeredCommandObject> commandMap = new HashMap<String, TriggeredCommandObject>();
        if (commandList != null) {
            for (TriggeredCommandObject command : commandList) {
                if (!commandMap.containsKey(command.commandID)) {
                    commandMap.put(command.commandID, command);
                }
                commandMap.get(command.commandID).incrementCounter();
            }
        }
        return commandMap.values();
    }
}
