/**
 * Copyright (c) 2014 Akif Etkue.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Akif Etkue - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.ui.data;

public enum WeekDays {

    MON("Mon", 1),
    TUE("Tue", 2),
    WED("Wed", 3),
    THU("Thu", 4),
    FRI("Fri", 5),
    SAT("Sat", 6),
    SUN("Sun", 7);

    private String day;

    WeekDays(String day, int order) {
        this.day = day;
    }

    public String getDay() {
        return day;
    }

    public static WeekDays getEnum(String day) {
        for (WeekDays weekday : WeekDays.values()) {
            if (weekday.getDay().equals(day)) {
                return weekday;
            }
        }
        return null;
    }
}
