/**
 * Copyright (c) 2013 Timur Achmetow.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Timur Achmetow - initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import com.google.common.base.Preconditions;

public class DateFormatter {

    public final String formatUnit(final Date past, final Date now) {
        Preconditions.checkNotNull(past);
        Preconditions.checkNotNull(now);

        final long minutes = TimeUnit.MILLISECONDS.toMinutes(now.getTime()
                - past.getTime());
        final long hours = TimeUnit.MILLISECONDS.toHours(now.getTime()
                - past.getTime());
        final long days = TimeUnit.MILLISECONDS.toDays(now.getTime()
                - past.getTime());

        if (days > 0) {
            return MessageFormat.format(
                    "{0,choice,1#1 day ago|1<{0,number,integer} days ago}",
                    days);
        } else if (hours > 0) {
            return MessageFormat.format(
                    "{0,choice,1#1 hour ago|1<{0,number,integer} hours ago}",
                    hours);
        } else if (minutes >= 0) {
            return MessageFormat
                    .format("{0,choice,0#0 minutes ago|1#1 minute ago|1<{0,number,integer} minutes ago}",
                            minutes);
        }
        return null;
    }
}
