/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.aether.SessionData;

public final class DefaultSessionData
implements SessionData {
    private final ConcurrentMap<Object, Object> data = new ConcurrentHashMap<Object, Object>();

    @Override
    public void set(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value != null) {
            this.data.put(key, value);
        } else {
            this.data.remove(key);
        }
    }

    @Override
    public boolean set(Object key, Object oldValue, Object newValue) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (newValue != null) {
            if (oldValue == null) {
                return this.data.putIfAbsent(key, newValue) == null;
            }
            return this.data.replace(key, oldValue, newValue);
        }
        if (oldValue == null) {
            return !this.data.containsKey(key);
        }
        return this.data.remove(key, oldValue);
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        return this.data.get(key);
    }
}

