/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import java.lang.reflect.Method;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.FilledArgumentNamesMethodProposal;
import org.eclipse.jdt.internal.ui.text.java.GetterSetterCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaFieldWithCastedReceiverCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyPackageCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodDeclarationCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.OverrideCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocInlineTagCompletionProposal;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocLinkTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposalFactory;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableAnonymousTypeCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableFilledArgumentNamesMethodProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableGetterSetterCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavaCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavaFieldWithCastedReceiverCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavaMethodCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavadocInlineTagCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavadocLinkTypeCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableLazyGenericTypeProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableLazyJavaCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableLazyJavaTypeCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableLazyPackageCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableMethodDeclarationCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableOverrideCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableParameterGuessingProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.internal.completion.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Reflections;

public class ProcessableProposalFactory
implements IProcessableProposalFactory {
    private static final String ORG_ECLIPSE_OBJECTTEAMS_OTDT = "org.eclipse.objectteams.otdt";
    private static Class<JavaMethodCompletionProposal> javaMethodCompletionProposalClass;
    private static Class<JavaFieldWithCastedReceiverCompletionProposal> javaFieldWithCastedReceiverCompletionProposalClass;
    private static Class<OverrideCompletionProposal> overrideCompletionProposalClass;
    private static Class<AnonymousTypeCompletionProposal> anonymousTypeCompletionProposalClass;
    private static Class<JavaCompletionProposal> javaCompletionProposalClass;
    private static Class<LazyGenericTypeProposal> lazyGenericTypeProposalClass;
    private static Class<LazyJavaTypeCompletionProposal> lazyJavaTypeCompletionProposalClass;
    private static Class<LazyJavaCompletionProposal> lazyJavaCompletionProposaClass;
    private static Class<FilledArgumentNamesMethodProposal> filledArgumentNamesMethodProposalClass;
    private static Class<ParameterGuessingProposal> parameterGuessingProposalClass;
    private static Class<MethodDeclarationCompletionProposal> methodDeclarationCompletionProposalClass;
    private static Class<LazyPackageCompletionProposal> lazyPackageCompletionProposalClass;
    private static Class<GetterSetterCompletionProposal> getterSetterCompletionProposalClass;
    private static Class<JavadocLinkTypeCompletionProposal> javadocLinkTypeCompletionProposalClass;
    private static Class<JavadocInlineTagCompletionProposal> javadocInlineTagCompletionProposalClass;
    private static Class<? extends LazyJavaCompletionProposal> lazyModuleCompletionProposals;
    private static Method GET_PROPOSAL_INFO;

    static {
        lazyModuleCompletionProposals = (Class)Reflections.loadClass((boolean)false, (ClassLoader)ProcessableProposalFactory.class.getClassLoader(), (String)"org.eclipse.jdt.internal.ui.text.java.LazyModuleCompletionProposal").orNull();
        try {
            javaMethodCompletionProposalClass = JavaMethodCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            javaFieldWithCastedReceiverCompletionProposalClass = JavaFieldWithCastedReceiverCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            overrideCompletionProposalClass = OverrideCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            anonymousTypeCompletionProposalClass = AnonymousTypeCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            javaCompletionProposalClass = JavaCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            lazyGenericTypeProposalClass = LazyGenericTypeProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            lazyJavaCompletionProposaClass = LazyJavaCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            lazyJavaTypeCompletionProposalClass = LazyJavaTypeCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            filledArgumentNamesMethodProposalClass = FilledArgumentNamesMethodProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            parameterGuessingProposalClass = ParameterGuessingProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            methodDeclarationCompletionProposalClass = MethodDeclarationCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            methodDeclarationCompletionProposalClass = MethodDeclarationCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            lazyPackageCompletionProposalClass = LazyPackageCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            getterSetterCompletionProposalClass = GetterSetterCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            javadocLinkTypeCompletionProposalClass = JavadocLinkTypeCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            javadocInlineTagCompletionProposalClass = JavadocInlineTagCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        GET_PROPOSAL_INFO = (Method)Reflections.getDeclaredMethod((boolean)true, AbstractJavaCompletionProposal.class, (String)"getProposalInfo", (Class[])new Class[0]).orNull();
    }

    private static void logWarning(NoClassDefFoundError e) {
        Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_LOAD_COMPLETION_PROPOSAL_CLASS, (Throwable)e);
    }

    public static IJavaCompletionProposal create(CompletionProposal coreProposal, IJavaCompletionProposal uiProposal, JavaContentAssistInvocationContext context, IProcessableProposalFactory factory) {
        Class<?> c = uiProposal.getClass();
        try {
            if (javaMethodCompletionProposalClass == c) {
                return factory.newJavaMethodCompletionProposal(coreProposal, (JavaMethodCompletionProposal)uiProposal, context);
            }
            if (javaFieldWithCastedReceiverCompletionProposalClass == c) {
                return factory.newJavaFieldWithCastedReceiverCompletionProposal(coreProposal, (JavaFieldWithCastedReceiverCompletionProposal)uiProposal, context);
            }
            if (overrideCompletionProposalClass == c) {
                return factory.newOverrideCompletionProposal(coreProposal, (OverrideCompletionProposal)uiProposal, context);
            }
            if (anonymousTypeCompletionProposalClass == c) {
                return factory.newAnonymousTypeCompletionProposal(coreProposal, (AnonymousTypeCompletionProposal)uiProposal, context);
            }
            if (javaCompletionProposalClass == c) {
                return factory.newJavaCompletionProposal(coreProposal, (JavaCompletionProposal)uiProposal, context);
            }
            if (lazyGenericTypeProposalClass == c) {
                return factory.newLazyGenericTypeProposal(coreProposal, (LazyGenericTypeProposal)uiProposal, context);
            }
            if (lazyJavaTypeCompletionProposalClass == c) {
                return factory.newLazyJavaTypeCompletionProposal(coreProposal, (LazyJavaTypeCompletionProposal)uiProposal, context);
            }
            if (filledArgumentNamesMethodProposalClass == c) {
                return factory.newFilledArgumentNamesMethodProposal(coreProposal, (FilledArgumentNamesMethodProposal)uiProposal, context);
            }
            if (parameterGuessingProposalClass == c) {
                return factory.newParameterGuessingProposal(coreProposal, (ParameterGuessingProposal)uiProposal, context);
            }
            if (methodDeclarationCompletionProposalClass == c) {
                return factory.newMethodDeclarationCompletionProposal(coreProposal, (MethodDeclarationCompletionProposal)uiProposal, context);
            }
            if (lazyPackageCompletionProposalClass == c) {
                return factory.newLazyPackageCompletionProposal(coreProposal, (LazyPackageCompletionProposal)uiProposal, context);
            }
            if (getterSetterCompletionProposalClass == c) {
                return factory.newGetterSetterCompletionProposal(coreProposal, (GetterSetterCompletionProposal)uiProposal, context);
            }
            if (javadocLinkTypeCompletionProposalClass == c) {
                return factory.newJavadocLinkTypeCompletionProposal(coreProposal, (JavadocLinkTypeCompletionProposal)uiProposal, context);
            }
            if (javadocInlineTagCompletionProposalClass == c) {
                return factory.newJavadocInlineTagCompletionProposal(coreProposal, (JavadocInlineTagCompletionProposal)uiProposal, context);
            }
            if (lazyJavaCompletionProposaClass == c || lazyModuleCompletionProposals == c) {
                return factory.newLazyJavaCompletionProposal(coreProposal, (LazyJavaCompletionProposal)uiProposal, context);
            }
            if (ProcessableProposalFactory.isWhitelisted(uiProposal, ORG_ECLIPSE_OBJECTTEAMS_OTDT)) {
                return uiProposal;
            }
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_UNEXPECTED_PROPOSAL_KIND, (Object[])new Object[]{c, uiProposal.getDisplayString()});
            return uiProposal;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_WRAP_JDT_PROPOSAL, (Throwable)e, (Object[])new Object[]{c, uiProposal.getDisplayString()});
            return uiProposal;
        }
    }

    private static boolean isWhitelisted(IJavaCompletionProposal uiProposal, String whitelistedPackage) {
        String uiProposalPackage = uiProposal.getClass().getPackage().getName();
        if (uiProposalPackage.startsWith(whitelistedPackage)) {
            if (uiProposalPackage.length() == whitelistedPackage.length()) {
                return true;
            }
            return uiProposalPackage.charAt(whitelistedPackage.length()) == '.';
        }
        return false;
    }

    @Override
    public IProcessableProposal newLazyGenericTypeProposal(CompletionProposal coreProposal, LazyGenericTypeProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableLazyGenericTypeProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newFilledArgumentNamesMethodProposal(CompletionProposal coreProposal, FilledArgumentNamesMethodProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableFilledArgumentNamesMethodProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newParameterGuessingProposal(CompletionProposal coreProposal, ParameterGuessingProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableParameterGuessingProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newAnonymousTypeCompletionProposal(CompletionProposal coreProposal, AnonymousTypeCompletionProposal uiProposal, JavaContentAssistInvocationContext context) throws JavaModelException {
        return this.postConstruct(ProcessableAnonymousTypeCompletionProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newJavaFieldWithCastedReceiverCompletionProposal(CompletionProposal coreProposal, JavaFieldWithCastedReceiverCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableJavaFieldWithCastedReceiverCompletionProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newJavaCompletionProposal(CompletionProposal coreProposal, JavaCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableJavaCompletionProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newJavadocLinkTypeCompletionProposal(CompletionProposal coreProposal, JavadocLinkTypeCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableJavadocLinkTypeCompletionProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newJavadocInlineTagCompletionProposal(CompletionProposal coreProposal, JavadocInlineTagCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableJavadocInlineTagCompletionProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newJavaMethodCompletionProposal(CompletionProposal coreProposal, JavaMethodCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableJavaMethodCompletionProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newLazyJavaTypeCompletionProposal(CompletionProposal coreProposal, LazyJavaTypeCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableLazyJavaTypeCompletionProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newOverrideCompletionProposal(CompletionProposal coreProposal, OverrideCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableOverrideCompletionProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newMethodDeclarationCompletionProposal(CompletionProposal coreProposal, MethodDeclarationCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableMethodDeclarationCompletionProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newGetterSetterCompletionProposal(CompletionProposal coreProposal, GetterSetterCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableGetterSetterCompletionProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newLazyPackageCompletionProposal(CompletionProposal coreProposal, LazyPackageCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableLazyPackageCompletionProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newLazyJavaCompletionProposal(CompletionProposal coreProposal, LazyJavaCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(ProcessableLazyJavaCompletionProposal.toProcessableProposal(uiProposal, coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    protected <T extends AbstractJavaCompletionProposal> T postConstruct(T processableProposal, AbstractJavaCompletionProposal originalProposal) {
        ((IProcessableProposal)processableProposal).setProposalProcessorManager(new ProposalProcessorManager((IProcessableProposal)processableProposal));
        processableProposal.setTriggerCharacters(originalProposal.getTriggerCharacters());
        ProcessableProposalFactory.copyProposalInfo((IJavaCompletionProposal)originalProposal, (IProcessableProposal)processableProposal);
        return processableProposal;
    }

    private static void copyProposalInfo(IJavaCompletionProposal originalProposal, IProcessableProposal processableProposal) {
        if (Checks.anyIsNull((Object[])new Object[]{GET_PROPOSAL_INFO, processableProposal, originalProposal})) {
            return;
        }
        try {
            ProposalInfo info = (ProposalInfo)GET_PROPOSAL_INFO.invoke((Object)originalProposal, new Object[0]);
            processableProposal.setProposalInfo(info);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_SET_PROPOSAL_INFO, (Throwable)e, (Object[])new Object[]{processableProposal});
        }
    }
}

