/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.news.api;

import java.net.URI;
import java.util.Date;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public final class NewsItem {
    private final String title;
    private final Date date;
    private final URI uri;
    private final String id;

    public NewsItem(String title, Date date, URI uri, @Nullable String id) {
        this.title = Objects.requireNonNull(title);
        this.date = Objects.requireNonNull(date);
        this.uri = Objects.requireNonNull(uri);
        this.id = id != null ? id : uri.toString();
    }

    public String getTitle() {
        return this.title;
    }

    public Date getDate() {
        return (Date)this.date.clone();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        NewsItem that = (NewsItem)other;
        return this.title.equals(that.title) && this.date.equals(that.date) && this.uri.equals(that.uri) && this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.date, this.uri, this.id);
    }

    public String toString() {
        return "'" + this.title + "' [" + this.id + "] @ <" + this.uri + "> on " + this.date;
    }
}

