/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.news.api.poll;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;

public abstract class PollingPolicy {
    public abstract boolean shouldPoll(@Nullable Date var1, Date var2);

    public static PollingPolicy always() {
        return new AlwaysPollingPolicy();
    }

    public static PollingPolicy never() {
        return new NeverPollingPolicy();
    }

    public static PollingPolicy every(long pollingInterval, TimeUnit timeUnit) {
        return new IntervalBasedPollingPolicy(pollingInterval, timeUnit);
    }

    private static final class AlwaysPollingPolicy
    extends PollingPolicy {
        private AlwaysPollingPolicy() {
        }

        @Override
        public boolean shouldPoll(@Nullable Date lastPolledDate, Date pollingDate) {
            return true;
        }
    }

    private static final class IntervalBasedPollingPolicy
    extends PollingPolicy {
        private final long pollingInterval;
        private final TimeUnit timeUnit;

        private IntervalBasedPollingPolicy(long pollingInterval, TimeUnit timeUnit) {
            this.pollingInterval = pollingInterval;
            this.timeUnit = timeUnit;
        }

        @Override
        public boolean shouldPoll(@Nullable Date lastPolledDate, Date pollingDate) {
            if (lastPolledDate == null) {
                return true;
            }
            long intervalMillis = this.timeUnit.toMillis(this.pollingInterval);
            Date nextPollingDate = new Date(lastPolledDate.getTime() + intervalMillis);
            return nextPollingDate.before(pollingDate);
        }
    }

    private static final class NeverPollingPolicy
    extends PollingPolicy {
        private NeverPollingPolicy() {
        }

        @Override
        public boolean shouldPoll(@Nullable Date lastPolledDate, Date pollingDate) {
            return false;
        }
    }
}

