/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Bags {
    private static final Comparator<Multiset.Entry<?>> BY_COUNT = new Comparator<Multiset.Entry<?>>(){

        @Override
        public int compare(Multiset.Entry<?> o1, Multiset.Entry<?> o2) {
            return ComparisonChain.start().compare(o1.getCount(), o2.getCount()).compare((Comparable)((Object)o1.getElement().toString()), (Comparable)((Object)o2.getElement().toString())).result();
        }
    };
    private static final Comparator<Multiset.Entry<?>> BY_STRING = new Comparator<Multiset.Entry<?>>(){

        @Override
        public int compare(Multiset.Entry<?> o1, Multiset.Entry<?> o2) {
            return ComparisonChain.start().compare((Comparable)((Object)o1.getElement().toString()), (Comparable)((Object)o2.getElement().toString())).compare(o1.getCount(), o2.getCount()).result();
        }
    };

    private Bags() {
    }

    public static <T> List<Multiset.Entry<T>> topUsingCount(Multiset<T> set, int i) {
        Set entries = set.entrySet();
        return Ordering.from(BY_COUNT).greatestOf((Iterable)entries, i);
    }

    public static <T> List<Multiset.Entry<T>> topUsingToString(Multiset<T> set, int i) {
        Set entries = set.entrySet();
        return Ordering.from(BY_STRING).greatestOf((Iterable)entries, i);
    }

    public static <T> List<Multiset.Entry<T>> orderedByToString(Multiset<T> set) {
        Set entries = set.entrySet();
        return Ordering.from(BY_STRING).sortedCopy((Iterable)entries);
    }

    public static <T> List<Multiset.Entry<T>> orderedByCount(Multiset<T> set) {
        Set entries = set.entrySet();
        return Ordering.from(BY_COUNT).reverse().sortedCopy((Iterable)entries);
    }

    public static <T> Multiset<T> newHashMultiset(Map<T, Integer> map) {
        HashMultiset res = HashMultiset.create((int)map.size());
        for (Map.Entry<T, Integer> e : map.entrySet()) {
            res.add(e.getKey(), e.getValue().intValue());
        }
        return res;
    }
}

