/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.navigator;

import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.exception.WorkbenchLayerException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ProjectExplorerTest {
    private ProjectExplorer projectExplorer;

    @Before
    public void before() {
        this.projectExplorer = new ProjectExplorer();
    }

    @After
    public void after() {
        if (this.projectExplorer.isOpen()) {
            this.projectExplorer.close();
        }
    }

    @Test
    public void open() {
        this.projectExplorer.open();
    }

    @Test
    public void getEmptyListOfProjects() {
        this.projectExplorer.open();
        Assert.assertEquals((long)this.projectExplorer.getProjects().size(), (long)0L);
    }

    @Test
    public void selectAllWithEmptyExplorer() {
        this.projectExplorer.open();
        try {
            this.projectExplorer.selectAllProjects();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Assert.fail((String)("Selecting all projects when there is none should do nothing, not throw an exception: " + exc.getCause() + " " + exc.getMessage()));
        }
    }

    @Test(expected=EclipseLayerException.class)
    public void selectProjectWithEmptyExplorer() {
        this.projectExplorer.open();
        this.projectExplorer.selectProjects(new String[]{"non-existing-project"});
    }

    @Test(expected=WorkbenchLayerException.class)
    public void getProjectsWhenExplorerIsClosed() {
        if (this.projectExplorer.isOpen()) {
            this.projectExplorer.close();
        }
        new ProjectExplorer().getProjects();
    }

    @Test
    public void testGetProjectsItemsEmpty() {
        this.projectExplorer.open();
        Assert.assertEquals((long)this.projectExplorer.getProjectItems().size(), (long)0L);
    }

    @Test
    public void testDeleteAllEmpty() {
        this.projectExplorer.open();
        this.projectExplorer.deleteAllProjects();
        this.projectExplorer.deleteAllProjects(true);
        this.projectExplorer.deleteAllProjects(false, TimePeriod.MEDIUM);
    }
}

