/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.condition;

import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.condition.TableHasRows;
import org.eclipse.reddeer.swt.impl.table.AbstractTableItem;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class TableHasRowsTest
extends SWTLayerTestCase {
    @Override
    protected void createControls(Shell shell) {
        shell.setLayout((Layout)new GridLayout());
        this.createSINGLETable(shell);
        this.createEmptyTable(shell);
    }

    private void createSINGLETable(Shell shell) {
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        Table table2 = new Table((Composite)shell, 4);
        table2.setLinesVisible(true);
        table2.setHeaderVisible(true);
        table2.setLayout((Layout)new GridLayout());
        table2.setLayoutData((Object)data);
        String[] titles = new String[]{" ", "C", "!", "Description", "Resource", "In Folder", "Location"};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table2, 0);
            column.setText(titles[i]);
            ++i;
        }
        int count = 128;
        int i2 = 0;
        while (i2 < count) {
            TableItem item = new TableItem(table2, 0);
            item.setText(0, "" + i2);
            item.setText(1, "a1");
            item.setText(2, "b" + i2);
            item.setText(3, "c " + i2);
            item.setText(4, "d" + i2);
            item.setText(5, "e" + i2);
            item.setText(6, "f" + i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < titles.length) {
            table2.getColumn(i2).pack();
            ++i2;
        }
        table2.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
                Table table = (Table)arg0.widget;
                int index = table.getSelectionIndex();
                TableItem doubleClickedItem = table.getItem(index);
                doubleClickedItem.setText(0, "single click");
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent arg0) {
                Table table = (Table)arg0.widget;
                int index = table.getSelectionIndex();
                TableItem doubleClickedItem = table.getItem(index);
                doubleClickedItem.setText(0, "double click");
            }
        });
    }

    private void createEmptyTable(Shell shell) {
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        Table table1 = new Table((Composite)shell, 2);
        table1.setLinesVisible(true);
        table1.setHeaderVisible(true);
        table1.setLayout((Layout)new GridLayout());
        table1.setLayoutData((Object)data);
        String[] titles = new String[]{" ", "C", "!", "Description", "Resource", "In Folder", "Location"};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table1, 0);
            column.setText(titles[i]);
            ++i;
        }
        i = 0;
        while (i < titles.length) {
            table1.getColumn(i).pack();
            ++i;
        }
    }

    @Test
    public void tableHasRows() {
        MatcherAssert.assertThat((String)"Table has rows", (boolean)new TableHasRows((org.eclipse.reddeer.swt.api.Table)new DefaultTable()).test());
    }

    @Test
    public void tableHasNotRows() {
        MatcherAssert.assertThat((String)"Table has not rows", (!new TableHasRows((org.eclipse.reddeer.swt.api.Table)new DefaultTable(1, new Matcher[0])).test() ? 1 : 0) != 0);
    }

    @Test
    public void tableCellColumnTest() {
        MatcherAssert.assertThat((String)"First column in table has cell with 126", (boolean)new TableHasRows((org.eclipse.reddeer.swt.api.Table)new DefaultTable(0, new Matcher[0]), (Matcher)new ColumnMatcher("126", 0)).test());
    }

    @Test
    public void tableCellColumnNotTest() {
        MatcherAssert.assertThat((String)"Table has not cell with regex .*abc.*", (!new TableHasRows((org.eclipse.reddeer.swt.api.Table)new DefaultTable(0, new Matcher[0]), (Matcher)new ColumnMatcher("128", 2)).test() ? 1 : 0) != 0);
    }

    @Test
    public void tableHasRowOutOfBoundExceptionTest() {
        MatcherAssert.assertThat((String)"Table has not column 10", (!new TableHasRows((org.eclipse.reddeer.swt.api.Table)new DefaultTable(), (Matcher)new ColumnMatcher("f", 10)).test() ? 1 : 0) != 0);
    }

    @Test
    public void tableContainsCellWithTextTest() {
        MatcherAssert.assertThat((String)"Table has not column 10", (!new TableHasRows((org.eclipse.reddeer.swt.api.Table)new DefaultTable(), (Matcher)new AllTableMatcher("c5")).test() ? 1 : 0) != 0);
    }

    @Test
    public void tableHasRowsGetResult() {
        TableHasRows condition = new TableHasRows((org.eclipse.reddeer.swt.api.Table)new DefaultTable(), (Matcher)new ColumnMatcher("a1", 1));
        TableHasRows condition2 = new TableHasRows((org.eclipse.reddeer.swt.api.Table)new DefaultTable(), (Matcher)new ColumnMatcher("xxx", 1));
        Assert.assertTrue((boolean)condition.test());
        MatcherAssert.assertThat((String)"Wait condition does not return expected number of rows", (condition.getResult().size() == 128 ? 1 : 0) != 0);
        Assert.assertTrue((!condition2.test() ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"Wait condition does not return null", (condition2.getResult() == null ? 1 : 0) != 0);
    }

    @Test
    public void tableHasRowsGetResultNoMatcher() {
        TableHasRows condition = new TableHasRows((org.eclipse.reddeer.swt.api.Table)new DefaultTable());
        Assert.assertTrue((boolean)condition.test());
        MatcherAssert.assertThat((String)"Wait condition is not null but should be", (condition.getResult() == null ? 1 : 0) != 0);
    }

    public class AllTableMatcher
    extends BaseMatcher<TableItem> {
        private String text;

        public AllTableMatcher(String text) {
            this.text = text;
        }

        public void describeTo(Description description) {
            description.appendText("Table contains at least one cell with text: " + this.text);
        }

        public boolean matches(Object item) {
            AbstractTableItem ti = (AbstractTableItem)item;
            int i = 0;
            while (i < 7) {
                if (ti.getText(i).contains(this.text)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public class ColumnMatcher
    extends BaseMatcher<TableItem> {
        private String text;
        private int column;

        public ColumnMatcher(String text, int column) {
            this.text = text;
            this.column = column;
        }

        public void describeTo(Description description) {
            description.appendText("Table cell contains text: " + this.text + "in column: " + this.column);
        }

        public boolean matches(Object item) {
            AbstractTableItem i = (AbstractTableItem)item;
            return i.getText(this.column).contains(this.text);
        }
    }
}

