/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.menu;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.test.handler.ParameterizedHandler;
import org.eclipse.reddeer.swt.test.handler.ViewActionWithId;
import org.eclipse.reddeer.workbench.impl.menu.WorkbenchPartMenuItem;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ViewMenuItemTest {
    @Test
    public void testErrorLogMenu() {
        new WorkbenchView("Error Log").open();
        new WorkbenchPartMenuItem(new String[]{"Filters..."}).select();
        new DefaultShell("Log Filters");
        new PushButton("OK").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable("Log Filters"));
        new WaitWhile((WaitCondition)new ShellIsAvailable("Progress Information"));
    }

    @Test
    public void testCheckStyledMenus() {
        new WorkbenchView("Error Log").open();
        WorkbenchPartMenuItem filter = new WorkbenchPartMenuItem(new String[]{"Show text filter"});
        boolean selected = filter.isSelected();
        if (selected) {
            filter.select();
            Assert.assertFalse((filter.isSelected() == selected ? 1 : 0) != 0);
            try {
                new DefaultText();
                Assert.fail();
            }
            catch (CoreLayerException coreLayerException) {}
        } else {
            filter.select();
            Assert.assertFalse((filter.isSelected() == selected ? 1 : 0) != 0);
            try {
                new DefaultText();
            }
            catch (CoreLayerException coreLayerException) {
                Assert.fail();
            }
        }
    }

    @Test
    public void parameterizedViewMenuItemTest() {
        new WorkbenchView("RedDeer SWT").open();
        new WorkbenchPartMenuItem(new String[]{"submenu", "parameterizedMenuA"}).select();
        Assert.assertTrue((boolean)ParameterizedHandler.isToggledA());
        Assert.assertFalse((boolean)ParameterizedHandler.isToggledB());
        new WorkbenchPartMenuItem(new String[]{"submenu", "parameterizedMenuB"}).select();
        Assert.assertTrue((boolean)ParameterizedHandler.isToggledA());
        Assert.assertTrue((boolean)ParameterizedHandler.isToggledB());
    }

    @Test
    public void actionWithIdViewMenuTest() {
        new WorkbenchView("RedDeer SWT").open();
        Assert.assertFalse((boolean)ViewActionWithId.isToggled());
        new WorkbenchPartMenuItem(new String[]{"View Action with ID"}).select();
        new WaitUntil((WaitCondition)new ViewWithActionIdIsToggled());
        Assert.assertTrue((boolean)ViewActionWithId.isToggled());
    }

    private class ViewWithActionIdIsToggled
    extends AbstractWaitCondition {
        private ViewWithActionIdIsToggled() {
        }

        public boolean test() {
            return ViewActionWithId.isToggled();
        }

        public String description() {
            return "ViewWithActionIsToggled.";
        }
    }
}

