/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.widgets;

import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.swt.test.utils.ShellTestUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Before;

public class DefaultWidgetAndControlBase {
    protected static final String SHELL_TITLE = "Testing shell";
    protected Menu widget;
    protected Button control;

    @Before
    public void setUp() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Shell shell = ShellTestUtils.createShell(DefaultWidgetAndControlBase.SHELL_TITLE);
                DefaultWidgetAndControlBase.this.createButton(shell);
                DefaultWidgetAndControlBase.this.createShellMenuBar(shell);
            }
        });
    }

    protected void createButton(Shell shell) {
        Button button = new Button((Composite)shell, 8);
        button.setText("Push Button");
        this.control = button;
    }

    public void createShellMenuBar(Shell shell) {
        Menu menu = new Menu((Decorations)shell, 2);
        MenuItem item = new MenuItem(menu, 64);
        item.setText("ShellMenuBarItem");
        shell.setMenuBar(menu);
        this.widget = menu;
    }

    @After
    public void cleanup() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ShellTestUtils.closeShell(DefaultWidgetAndControlBase.SHELL_TITLE);
            }
        });
    }
}

