/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.m2e.core.ui.preferences;

import java.io.File;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.m2e.core.ui.preferences.MavenArchetypesPreferencePage;
import org.eclipse.reddeer.eclipse.test.Activator;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class MavenArchetypesPreferencePageTest {
    private static final String LOCAL_CATALOG_DESCRIPTION = "Local Test Catalog";
    private static final String REMOTE_CATALOG_FILE = "http://repo1.maven.org/maven2/archetype-catalog.xml";
    private static final String REMOTE_CATALOG_DESCRIPTION = "Remote Test Catalog";
    private static final String EMPTY_CATALOG_MESSAGE = "Remote catalog is empty";
    private WorkbenchPreferenceDialog preferencesDialog = new WorkbenchPreferenceDialog();
    private MavenArchetypesPreferencePage page = new MavenArchetypesPreferencePage((ReferencedComposite)this.preferencesDialog);
    private File path = new File(Activator.getTestResourcesLocation(MavenArchetypesPreferencePageTest.class), "archetype-catalog.xml");

    @After
    public void tearDown() {
        this.preferencesDialog.cancel();
    }

    @Test
    public void setLocalCatalogTest() {
        this.preferencesDialog.open();
        this.preferencesDialog.select((PreferencePage)this.page);
        this.page.addLocalCatalog(this.path.getAbsolutePath(), LOCAL_CATALOG_DESCRIPTION);
        Assert.assertEquals((Object)true, (Object)this.page.containsCatalog("Local: Local Test Catalog"));
        this.page.removeCatalog("Local: Local Test Catalog");
        Assert.assertEquals((Object)false, (Object)this.page.containsCatalog("Local: Local Test Catalog"));
    }

    @Test
    public void editLocalCatalogTest() {
        String localCatalogName = "Local: Local Test Catalog";
        this.preferencesDialog.open();
        this.preferencesDialog.select((PreferencePage)this.page);
        this.page.addLocalCatalog(this.path.getAbsolutePath(), LOCAL_CATALOG_DESCRIPTION);
        Assert.assertEquals((Object)true, (Object)this.page.containsCatalog(localCatalogName));
        localCatalogName = String.valueOf(localCatalogName) + " test";
        this.page.editLocalCatalog(localCatalogName, this.path.getAbsolutePath(), localCatalogName);
        this.page.removeCatalog(localCatalogName);
        Assert.assertEquals((Object)false, (Object)this.page.containsCatalog(localCatalogName));
    }

    @Test
    public void setRemoteCatalogTest() {
        this.preferencesDialog.open();
        this.preferencesDialog.select((PreferencePage)this.page);
        Assert.assertNotEquals((Object)EMPTY_CATALOG_MESSAGE, (Object)this.page.addRemoteCatalog(REMOTE_CATALOG_FILE, REMOTE_CATALOG_DESCRIPTION));
        Assert.assertEquals((Object)true, (Object)this.page.containsCatalog("Remote: Remote Test Catalog"));
        this.page.removeCatalog("Remote: Remote Test Catalog");
        Assert.assertEquals((Object)false, (Object)this.page.containsCatalog("Remote: Remote Test Catalog"));
    }

    @Test
    public void editRemoteCatalogTest() {
        String remoteCatalogName = "Remote: Remote Test Catalog";
        this.preferencesDialog.open();
        this.preferencesDialog.select((PreferencePage)this.page);
        Assert.assertNotEquals((Object)EMPTY_CATALOG_MESSAGE, (Object)this.page.addRemoteCatalog(REMOTE_CATALOG_FILE, REMOTE_CATALOG_DESCRIPTION));
        Assert.assertEquals((Object)true, (Object)this.page.containsCatalog(remoteCatalogName));
        remoteCatalogName = String.valueOf(remoteCatalogName) + " test";
        Assert.assertNotEquals((Object)EMPTY_CATALOG_MESSAGE, (Object)this.page.editRemoteCatalog(remoteCatalogName, REMOTE_CATALOG_FILE, remoteCatalogName));
        Assert.assertEquals((Object)true, (Object)this.page.containsCatalog("Remote: " + remoteCatalogName));
        this.page.removeCatalog(remoteCatalogName);
        Assert.assertEquals((Object)false, (Object)this.page.containsCatalog(remoteCatalogName));
    }

    @Test
    public void setRemoteCatalogNotVerifyTest() {
        this.preferencesDialog.open();
        this.preferencesDialog.select((PreferencePage)this.page);
        Assert.assertEquals((Object)"", (Object)this.page.addRemoteCatalog("http://repo1.maven.org/maven2/archetype-catalog.xml_test", REMOTE_CATALOG_DESCRIPTION, false));
        Assert.assertEquals((Object)true, (Object)this.page.containsCatalog("Remote: Remote Test Catalog"));
        this.page.removeCatalog("Remote: Remote Test Catalog");
        Assert.assertEquals((Object)false, (Object)this.page.containsCatalog("Remote: Remote Test Catalog"));
    }

    @Test
    public void editRemoteCatalogNotVerifyTest() {
        String remoteCatalogName = "Remote: Remote Test Catalog";
        this.preferencesDialog.open();
        this.preferencesDialog.select((PreferencePage)this.page);
        this.page.addRemoteCatalog(REMOTE_CATALOG_FILE, REMOTE_CATALOG_DESCRIPTION);
        Assert.assertEquals((Object)true, (Object)this.page.containsCatalog(remoteCatalogName));
        remoteCatalogName = String.valueOf(remoteCatalogName) + " test";
        Assert.assertEquals((Object)"", (Object)this.page.editRemoteCatalog(remoteCatalogName, "http://repo1.maven.org/maven2/archetype-catalog.xmlabc", remoteCatalogName, false));
        Assert.assertEquals((Object)true, (Object)this.page.containsCatalog("Remote: " + remoteCatalogName));
        this.page.removeCatalog(remoteCatalogName);
        Assert.assertEquals((Object)false, (Object)this.page.containsCatalog(remoteCatalogName));
    }
}

