/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.ide;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.equinox.security.ui.storage.PasswordProvider;
import org.eclipse.reddeer.eclipse.equinox.security.ui.storage.StoragePreferencePage;
import org.eclipse.reddeer.eclipse.mylyn.tasks.ui.views.TaskRepositoriesView;
import org.eclipse.reddeer.eclipse.mylyn.tasks.ui.views.TaskRepository;
import org.eclipse.reddeer.eclipse.mylyn.tasks.ui.wizards.TaskRepositoryWizardDialog;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class RepoConnectionDialogTest {
    TaskRepositoryWizardDialog repoConnectionDialog = null;

    @Before
    public void disableSecureStorage() {
        this.setEnabledMasterPasswordPrompt(false);
    }

    @Test
    public void getDialogTest() {
        TaskRepositoriesView repositoriesView = new TaskRepositoriesView();
        repositoriesView.open();
        TaskRepository repo = repositoriesView.getTaskRepository("Local");
        this.repoConnectionDialog = repo.openProperties();
        Assert.assertTrue((String)"Properties title matches", (boolean)this.repoConnectionDialog.getShell().getText().equals("Properties for Task Repository"));
        this.repoConnectionDialog.cancel();
        this.repoConnectionDialog = null;
    }

    @After
    public void tearDown() {
        if (this.repoConnectionDialog != null) {
            this.repoConnectionDialog.cancel();
        }
        this.setEnabledMasterPasswordPrompt(true);
    }

    private void setEnabledMasterPasswordPrompt(boolean enabled) {
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        StoragePreferencePage storagePage = new StoragePreferencePage((ReferencedComposite)preferenceDialog);
        preferenceDialog.open();
        preferenceDialog.select((PreferencePage)storagePage);
        for (PasswordProvider provider : storagePage.getMasterPasswordProviders()) {
            provider.setEnabled(enabled);
        }
        storagePage.apply();
        preferenceDialog.ok();
    }
}

