/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.part;

import java.io.File;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.test.Activator;
import org.eclipse.reddeer.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizardDialog;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.WizardProjectsImportPage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.styledtext.DefaultStyledText;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class MultiPageEditorTest {
    public static final File ZIP_FILE = new File(Activator.getTestResourcesLocation(MultiPageEditorTest.class), "xml-project.zip");
    protected static final String PROJECT_NAME = "xml-project";
    protected static final String FILE_NAME = "file.xml";
    private static MultiPageEditorPart editor;

    @BeforeClass
    public static void importProject() {
        ExternalProjectImportWizardDialog wizard = new ExternalProjectImportWizardDialog();
        wizard.open();
        WizardProjectsImportPage wizardPage = new WizardProjectsImportPage((ReferencedComposite)wizard);
        wizardPage.setArchiveFile(ZIP_FILE.getAbsolutePath());
        wizardPage.selectProjects(new String[]{PROJECT_NAME});
        wizard.finish();
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        explorer.getProject(PROJECT_NAME).getProjectItem(new String[]{FILE_NAME}).open();
        editor = new MultiPageEditorPart(FILE_NAME);
    }

    @AfterClass
    public static void cleanProject() {
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        explorer.getProject(PROJECT_NAME).delete(true);
    }

    @Test
    public void selectPage() {
        editor.selectPage("Design");
        new DefaultTreeItem(new String[]{"a", "b1"});
        new PackageExplorerPart().open();
        editor.selectPage("Source");
        Assert.assertTrue((boolean)new DefaultStyledText().getText().contains("</a>"));
    }
}

