/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.html.ui.wizard;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jst.servlet.ui.project.facet.WebProjectFirstPage;
import org.eclipse.reddeer.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.reddeer.eclipse.wst.html.ui.wizard.NewHTMLFileWizardPage;
import org.eclipse.reddeer.eclipse.wst.html.ui.wizard.NewHTMLTemplatesWizardPage;
import org.eclipse.reddeer.eclipse.wst.html.ui.wizard.NewHTMLWizard;
import org.eclipse.reddeer.jface.wizard.WizardDialog;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.cleanworkspace.CleanWorkspaceRequirement;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class HTMLWizardTest {
    @BeforeClass
    public static void prepareWorkspace() {
        WebProjectWizard wd = new WebProjectWizard();
        wd.open();
        WebProjectFirstPage wp = new WebProjectFirstPage((WizardDialog)wd);
        wp.setProjectName("HTMLProjectTest");
        wd.finish();
    }

    @AfterClass
    public static void deleteWorkspace() {
        new CleanWorkspaceRequirement().fulfill();
    }

    @Test
    public void createHTMLFile() {
        NewHTMLWizard hw = new NewHTMLWizard();
        hw.open();
        NewHTMLFileWizardPage hp = new NewHTMLFileWizardPage((ReferencedComposite)hw);
        hp.setFileName("testHTML");
        Assert.assertEquals((Object)"testHTML", (Object)hp.getFileName());
        Assert.assertEquals((Object)"WebContent", (Object)hp.getSelectedParentFolder().getText());
        hp.selectParentFolder(new String[]{"HTMLProjectTest", "src"});
        Assert.assertEquals((Object)"src", (Object)hp.getSelectedParentFolder().getText());
        hw.next();
        NewHTMLTemplatesWizardPage tp = new NewHTMLTemplatesWizardPage((ReferencedComposite)hw);
        tp.toggleUseHTMLTemplate(false);
        Assert.assertFalse((boolean)tp.isUseHTMLTeplate());
        tp.toggleUseHTMLTemplate(true);
        Assert.assertTrue((boolean)tp.isUseHTMLTeplate());
        Assert.assertNotNull((Object)tp.getHTMLTemplate());
        hw.finish();
    }
}

