/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.test.condition;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.junit.After;
import org.junit.Assert;

public abstract class JobTestBase {
    private final Map<String, Job> scheduledJobs = new HashMap<String, Job>();
    private final Logger log = Logger.getLogger(JobTestBase.class);

    protected void assertRunning(String name) {
        Assert.assertTrue((String)("Job '" + name + "' is not running!"), (boolean)this.isRunning(name));
    }

    protected void assertNotRunning(String name) {
        Assert.assertFalse((String)("Job '" + name + "' is not finisched yet!"), (boolean)this.isRunning(name));
    }

    @After
    public void killScheduledJobs() {
        for (Job job : this.scheduledJobs.values()) {
            if (!this.isRunning(job)) continue;
            try {
                this.killJob(job);
            }
            catch (CannotKillJobException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                Assert.fail((String)e.getMessage());
            }
        }
        this.scheduledJobs.clear();
    }

    protected void runParallelyForSeconds(String name, int seconds) {
        this.runJob(name, seconds, false);
    }

    protected void runParallelyForSecondsAsSystem(String name, int seconds) {
        this.runJob(name, seconds, true);
    }

    private void runJob(String name, final int seconds, boolean isSystem) {
        Job job = new Job(name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int i = 0;
                    while (i < seconds) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        Thread.sleep(1000L);
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(isSystem);
        this.ensureRunning(job);
    }

    private void ensureRunning(final Job job) {
        this.scheduledJobs.put(job.getName(), job);
        job.schedule();
        new WaitUntil((WaitCondition)new AbstractWaitCondition(){

            public boolean test() {
                return JobTestBase.this.isRunning(job);
            }
        }, TimePeriod.DEFAULT);
    }

    private boolean isRunning(String name) {
        return this.isRunning(this.scheduledJobs.get(name));
    }

    private boolean isRunning(Job job) {
        return job != null && 4 == job.getState();
    }

    private void killJob(Job job) throws CannotKillJobException {
        int i = 1;
        int maxAttempts = 3;
        while (i <= maxAttempts) {
            boolean success = job.cancel();
            if (success) {
                this.log.info("Job '" + job.getName() + "' was successfully killed");
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new CannotKillJobException((Throwable)e);
            }
            ++i;
        }
        throw new CannotKillJobException("Job '" + job.getName() + "' was not killed!");
    }

    private class CannotKillJobException
    extends Exception {
        private static final long serialVersionUID = 4759327093361777991L;

        CannotKillJobException(String msg) {
            super(msg);
        }

        CannotKillJobException(Throwable throwable) {
            super(throwable);
        }
    }
}

