/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.Messages;
import org.osgi.framework.Bundle;

public class InstallableRuntime
implements IInstallableRuntime {
    private IConfigurationElement element;

    public InstallableRuntime(IConfigurationElement element) {
        this.element = element;
    }

    @Override
    public String getId() {
        try {
            return this.element.getAttribute("id");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getName() {
        return String.valueOf(this.getPath());
    }

    public String getFeatureVersion() {
        try {
            return this.element.getAttribute("featureVersion");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFeatureId() {
        try {
            return this.element.getAttribute("featureId");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getBundleId() {
        try {
            return this.element.getAttribute("bundleId");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getBundleVersion() {
        try {
            return this.element.getAttribute("bundleVersion");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getPath() {
        try {
            return this.element.getAttribute("path");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFromSite() {
        try {
            return this.element.getAttribute("featureSite");
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Bundle getBundleVersion(Bundle[] bundles, String version) {
        if (bundles == null) {
            return null;
        }
        int size = bundles.length;
        return bundles[size - 1];
    }

    @Override
    public void install(final IPath path) {
        Job installRuntimeJob = new Job(Messages.jobInstallingRuntime){

            public boolean belongsTo(Object family) {
                return "org.eclipse.wst.server.core".equals(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    InstallableRuntime.this.install(path, monitor);
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        installRuntimeJob.schedule();
    }

    public String toString() {
        return "InstallableRuntime[" + this.getId() + "]";
    }

    @Override
    public String getLicense(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    @Override
    public void install(IPath path, IProgressMonitor monitor) throws CoreException {
    }
}

