/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.gef.util;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.reddeer.gef.handler.ViewerHandler;
import org.eclipse.reddeer.gef.lookup.ViewerLookup;

public class DumpUtils {
    public static void dump() {
        DumpUtils.dump((EditPartViewer)ViewerLookup.getInstance().findGraphicalViewer());
    }

    public static void dump(EditPartViewer viewer) {
        DumpUtils.dump("====== All Figures ======", 0);
        DumpUtils.dump(ViewerHandler.getInstance().getFigureCanvas(viewer).getContents(), 0);
        DumpUtils.dump("====== Edit Parts ======", 0);
        DumpUtils.dump(viewer.getContents(), 0);
        DumpUtils.dump("===================", 0);
    }

    public static void dump(EditPart parent, int indent) {
        DumpUtils.dump(parent.getClass(), indent);
        if (parent instanceof GraphicalEditPart) {
            DumpUtils.dump(((GraphicalEditPart)parent).getFigure(), indent + 1);
        }
        List editParts = parent.getChildren();
        for (EditPart editPart : editParts) {
            DumpUtils.dump(editPart, indent + 1);
        }
    }

    public static void dump(IFigure parent, int indent) {
        IFigure tooltip;
        DumpUtils.dump(parent.getClass(), indent);
        if (parent instanceof Label) {
            DumpUtils.dump("> Label: " + ((Label)parent).getText(), indent + 1);
        }
        if (parent instanceof TextFlow) {
            DumpUtils.dump("> TextFlow: " + ((TextFlow)parent).getText(), indent + 1);
        }
        if ((tooltip = parent.getToolTip()) instanceof Label) {
            DumpUtils.dump("> Tooltip: " + ((Label)tooltip).getText(), indent + 1);
        }
        List list = parent.getChildren();
        for (IFigure figure : list) {
            DumpUtils.dump(figure, indent + 1);
        }
    }

    public static void dump(Object obj, int indent) {
        int i = 0;
        while (i < indent) {
            System.out.print("  ");
            ++i;
        }
        System.out.println(obj);
    }
}

