/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.test.wait;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.test.wait.CustomWaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WaitWhileTest {
    private WaitCondition trueCondition;

    @Before
    public void setupCondition() {
        this.trueCondition = new CustomWaitCondition(true, 5, () -> CustomWaitCondition.sleep(1000L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NullCondition() {
        new WaitWhile(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NullTimePeriod() {
        new WaitWhile(this.trueCondition, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_IllegalTimePeriod() {
        new WaitWhile(this.trueCondition, TimePeriod.getCustom((long)-1L));
    }

    @Test(expected=WaitTimeoutExpiredException.class)
    public void test_ThrowingException() {
        new WaitWhile(this.trueCondition, TimePeriod.SHORT);
    }

    @Test
    public void test_NotThrowingException() {
        try {
            new WaitWhile(this.trueCondition, TimePeriod.MEDIUM, false);
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.fail((String)"WaitTimeoutExpiredException should not be thrown");
        }
    }

    @Test
    public void test_WaitWhileFulFilled() {
        try {
            new WaitWhile(this.trueCondition, TimePeriod.DEFAULT);
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.fail((String)"WaitTimeoutExpiredException should not be thrown");
        }
    }
}

