/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.tree;

import java.util.Arrays;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.TreeItemRegexMatcher;
import org.eclipse.reddeer.core.matcher.TreeItemTextMatcher;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.swt.test.impl.tree.AbstractTreeTest;
import org.eclipse.reddeer.swt.test.ui.views.TreeEventsListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultTreeItemTest
extends AbstractTreeTest {
    protected org.eclipse.reddeer.swt.api.Tree tree;
    private boolean threadAlreadyRunning = false;
    private Thread generateDynamicTreeItems = null;

    @Override
    protected void createControls(Shell shell) {
        super.createControls(shell);
    }

    @Before
    public void initTree() {
        this.tree = new DefaultTree();
    }

    @Test
    public void testFindExistingItemByPath() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        DefaultTreeItem dfi = new DefaultTreeItem(new String[]{"A", "AA", "AAB"});
        Assert.assertTrue((String)("Founded Tree Item has to have text AAB but has " + dfi.getText()), (boolean)dfi.getText().equals("AAB"));
    }

    @Test
    public void testGetParentItem() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        DefaultTreeItem dfi = new DefaultTreeItem(new String[]{"A", "AA"});
        org.eclipse.reddeer.swt.api.TreeItem parentItem = dfi.getParentItem();
        Assert.assertEquals((Object)"A", (Object)parentItem.getText());
    }

    @Test(expected=CoreLayerException.class)
    public void testFindNonExistingItemByPath() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        new DefaultTreeItem(new String[]{"A", "AA", "NONEXISTINGTEXT"});
    }

    @Test
    public void getItem() {
        int cellIndex = 0;
        this.createTreeItems((Tree)this.tree.getSWTWidget(), cellIndex);
        String expectedText = "AA";
        DefaultTree dt = new DefaultTree();
        org.eclipse.reddeer.swt.api.TreeItem dfi = new DefaultTreeItem((org.eclipse.reddeer.swt.api.Tree)dt, new String[]{"A"}).getItem("AA");
        Assert.assertTrue((String)String.format("Found Tree Item has to have text '%s', '%s' found instead", expectedText, dfi.getCell(cellIndex)), (boolean)dfi.getCell(cellIndex).equals(expectedText));
    }

    @Test
    public void getItemByPath() {
        int cellIndex = 0;
        this.createTreeItems((Tree)this.tree.getSWTWidget(), cellIndex);
        String expectedText = "AAB";
        DefaultTree dt = new DefaultTree();
        org.eclipse.reddeer.swt.api.TreeItem dfi = new DefaultTreeItem((org.eclipse.reddeer.swt.api.Tree)dt, new String[]{"A"}).getItem(new String[]{"AA", "AAB"});
        Assert.assertTrue((String)String.format("Found Tree Item has to have text '%s', '%s' found instead", expectedText, dfi.getCell(cellIndex)), (boolean)dfi.getCell(cellIndex).equals(expectedText));
    }

    @Test
    public void testFindExistingItemByPathMatchers() {
        int cellIndex = 1;
        this.createTreeItems((Tree)this.tree.getSWTWidget(), cellIndex);
        String expectedText = "AAB";
        DefaultTree dt = new DefaultTree();
        DefaultTreeItem dfi = new DefaultTreeItem((org.eclipse.reddeer.swt.api.Tree)dt, new Matcher[]{new TreeItemTextMatcher("A", cellIndex), new TreeItemTextMatcher("AA", cellIndex), new TreeItemTextMatcher("AAB", cellIndex)});
        Assert.assertTrue((String)String.format("Found Tree Item has to have text '%s', '%s' found instead", expectedText, dfi.getCell(cellIndex)), (boolean)dfi.getCell(cellIndex).equals(expectedText));
    }

    @Test
    public void testFindUsingRegexMatchersAndIndex() {
        TreeItemRegexMatcher aMatcher = new TreeItemRegexMatcher("A");
        TreeItemRegexMatcher aPlusMatcher = new TreeItemRegexMatcher("A+");
        TreeItemRegexMatcher aPlusBMatcher = new TreeItemRegexMatcher("AA.");
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        String expected = "AAB";
        DefaultTreeItem dfi = new DefaultTreeItem(1, new Matcher[]{aMatcher, aPlusMatcher, aPlusBMatcher});
        Assert.assertEquals((String)String.format("Found item with text '%s', '%s' expected", dfi.getText(), expected), (Object)expected, (Object)dfi.getText());
    }

    @Test
    public void testFindUsingIndex() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        new DefaultTreeItem(0, new Matcher[0]);
    }

    @Test
    public void testExpandCollapse() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        DefaultTreeItem dfi = new DefaultTreeItem(new String[]{"A", "AA"});
        TreeEventsListener treeEventsListener = new TreeEventsListener((Tree)dfi.getParent().getSWTWidget());
        treeEventsListener.addListeners();
        if (dfi.isExpanded()) {
            dfi.collapse();
            Assert.assertTrue((String)"TreeItem is not collapsed", (!dfi.isExpanded() ? 1 : 0) != 0);
            Assert.assertNotNull((String)"Collapse event was not fired", (Object)treeEventsListener.getCollapsedTreeItem());
            Assert.assertTrue((String)("Incorrect tree item was collapsed: " + treeEventsListener.getCollapsedTreeItem().getText()), (boolean)treeEventsListener.getCollapsedTreeItem().getText().equals(dfi.getText()));
            treeEventsListener.resetListeningWatchers();
            dfi.expand();
            Assert.assertTrue((String)"TreeItem is not expanded", (boolean)dfi.isExpanded());
            Assert.assertNotNull((String)"Expand event was not fired", (Object)treeEventsListener.getExpandedTreeItem());
            Assert.assertTrue((String)("Incorrect tree item was expanded: " + treeEventsListener.getExpandedTreeItem().getText()), (boolean)treeEventsListener.getExpandedTreeItem().getText().equals(dfi.getText()));
        } else {
            dfi.expand();
            Assert.assertTrue((String)"TreeItem is not expanded", (boolean)dfi.isExpanded());
            Assert.assertNotNull((String)"Expand event was not fired", (Object)treeEventsListener.getExpandedTreeItem());
            Assert.assertTrue((String)("Incorrect tree item was expanded: " + treeEventsListener.getExpandedTreeItem().getText()), (boolean)treeEventsListener.getExpandedTreeItem().getText().equals(dfi.getText()));
            treeEventsListener.resetListeningWatchers();
            dfi.collapse();
            Assert.assertTrue((String)"TreeItem is not collapsed", (!dfi.isExpanded() ? 1 : 0) != 0);
            Assert.assertNotNull((String)"Collapse event was not fired", (Object)treeEventsListener.getCollapsedTreeItem());
            Assert.assertTrue((String)("Incorrect tree item was collapsed: " + treeEventsListener.getCollapsedTreeItem().getText()), (boolean)treeEventsListener.getCollapsedTreeItem().getText().equals(dfi.getText()));
        }
        treeEventsListener.removeListeners();
    }

    @Test
    public void testCheckUncheck() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        DefaultTreeItem dfi = new DefaultTreeItem(new String[]{"A", "AA"});
        TreeEventsListener treeEventsListener = new TreeEventsListener((Tree)dfi.getParent().getSWTWidget());
        treeEventsListener.addListeners();
        dfi.setChecked(true);
        Assert.assertTrue((String)"TreeItem is not checked", (boolean)dfi.isChecked());
        Assert.assertTrue((String)"Selection event was not fired", (boolean)treeEventsListener.wasSelectionEvent());
        Assert.assertTrue((String)("Incorrect tree item was selected: " + treeEventsListener.getSelectedTreeItem().getText()), (boolean)treeEventsListener.getSelectedTreeItem().getText().equals(dfi.getText()));
        Assert.assertTrue((String)"Selection event has not been check event", (boolean)treeEventsListener.wasCheckEvent());
        treeEventsListener.resetListeningWatchers();
        dfi.setChecked(false);
        Assert.assertTrue((String)"TreeItem is checked", (!dfi.isChecked() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Selection event was not fired", (boolean)treeEventsListener.wasSelectionEvent());
        Assert.assertTrue((String)("Incorrect tree item was selected: " + treeEventsListener.getSelectedTreeItem().getText()), (boolean)treeEventsListener.getSelectedTreeItem().getText().equals(dfi.getText()));
        Assert.assertTrue((String)"Selection event has not been check event", (boolean)treeEventsListener.wasCheckEvent());
        treeEventsListener.removeListeners();
    }

    @Test
    public void testSelect() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        DefaultTreeItem dfi = new DefaultTreeItem(new String[]{"A", "AA"});
        TreeEventsListener treeEventsListener = new TreeEventsListener((Tree)dfi.getParent().getSWTWidget());
        treeEventsListener.addListeners();
        dfi.select();
        Assert.assertTrue((String)"TreeItem is not selected", (boolean)dfi.isSelected());
        Assert.assertTrue((String)"Selection event was not fired", (boolean)treeEventsListener.wasSelectionEvent());
        Assert.assertTrue((String)("Incorrect tree item was selected: " + treeEventsListener.getSelectedTreeItem().getText()), (boolean)treeEventsListener.getSelectedTreeItem().getText().equals(dfi.getText()));
        Assert.assertFalse((String)"Selection event has been check event", (boolean)treeEventsListener.wasCheckEvent());
        treeEventsListener.removeListeners();
    }

    @Test
    public void testSelectUnselectItems() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        DefaultTreeItem dfi0 = new DefaultTreeItem(new String[]{"A", "AA", "AAA"});
        DefaultTreeItem dfi1 = new DefaultTreeItem(new String[]{"B", "BB"});
        DefaultTreeItem dfi2 = new DefaultTreeItem(new String[]{"A", "AA", "AAB"});
        DefaultTreeItem dfi3 = new DefaultTreeItem(new String[]{"C"});
        DefaultTreeItem dfiNotSelected = new DefaultTreeItem(new String[]{"A", "AA"});
        TreeEventsListener treeEventsListener = new TreeEventsListener((Tree)dfi0.getParent().getSWTWidget());
        treeEventsListener.addListeners();
        dfi0.getParent().selectItems(new org.eclipse.reddeer.swt.api.TreeItem[]{dfi0, dfi1, dfi2, dfi3});
        Assert.assertTrue((String)("TreeItem " + this.printFormattedStringArray(dfi0.getPath()) + " is not selected"), (boolean)dfi0.isSelected());
        Assert.assertTrue((String)("TreeItem " + this.printFormattedStringArray(dfi1.getPath()) + " is not selected"), (boolean)dfi1.isSelected());
        Assert.assertTrue((String)("TreeItem " + this.printFormattedStringArray(dfi2.getPath()) + " is not selected"), (boolean)dfi2.isSelected());
        Assert.assertTrue((String)("TreeItem " + this.printFormattedStringArray(dfi3.getPath()) + " is not selected"), (boolean)dfi3.isSelected());
        Assert.assertFalse((String)("TreeItem " + this.printFormattedStringArray(dfi3.getPath()) + " is selected"), (boolean)dfiNotSelected.isSelected());
        Assert.assertTrue((String)"Selection event was not fired", (boolean)treeEventsListener.wasSelectionEvent());
        Assert.assertFalse((String)"Selection event has been check event", (boolean)treeEventsListener.wasCheckEvent());
        treeEventsListener.resetListeningWatchers();
        dfi0.getParent().unselectAllItems();
        Assert.assertFalse((String)"Selection event has been check event", (boolean)treeEventsListener.wasCheckEvent());
        Assert.assertFalse((String)("TreeItem " + this.printFormattedStringArray(dfi0.getPath()) + " is selected"), (boolean)dfi0.isSelected());
        Assert.assertFalse((String)("TreeItem " + this.printFormattedStringArray(dfi1.getPath()) + " is selected"), (boolean)dfi1.isSelected());
        Assert.assertFalse((String)("TreeItem " + this.printFormattedStringArray(dfi2.getPath()) + " is selected"), (boolean)dfi2.isSelected());
        Assert.assertFalse((String)("TreeItem " + this.printFormattedStringArray(dfi3.getPath()) + " is selected"), (boolean)dfi3.isSelected());
        Assert.assertFalse((String)("TreeItem " + this.printFormattedStringArray(dfi3.getPath()) + " is selected"), (boolean)dfiNotSelected.isSelected());
        treeEventsListener.removeListeners();
    }

    @Test
    public void testDoubleClick() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        DefaultTreeItem dfi = new DefaultTreeItem(new String[]{"A", "AA"});
        TreeEventsListener treeEventsListener = new TreeEventsListener((Tree)dfi.getParent().getSWTWidget());
        treeEventsListener.addListeners();
        dfi.doubleClick();
        Assert.assertTrue((String)"Selection event was not fired", (boolean)treeEventsListener.wasSelectionEvent());
        Assert.assertTrue((String)"MouseDoubleClick event was not fired", (boolean)treeEventsListener.wasMouseDoubleClickEvent());
        Assert.assertNotNull((String)"DefaultSelection event was not fired", (Object)treeEventsListener.getDefaultSelectedTreeItem());
        Assert.assertTrue((String)"TreeItem is not selected", (boolean)dfi.isSelected());
        Assert.assertTrue((String)("Incorrect tree item was selected: " + treeEventsListener.getDefaultSelectedTreeItem().getText()), (boolean)treeEventsListener.getDefaultSelectedTreeItem().getText().equals(dfi.getText()));
        treeEventsListener.removeListeners();
    }

    @Test
    public void testGetPath() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        Object[] expectedPath = new String[]{"A", "AA", "AAA"};
        DefaultTreeItem dfi = new DefaultTreeItem((String[])expectedPath);
        Object[] path = dfi.getPath();
        if (!Arrays.equals(path, expectedPath)) {
            Assert.fail((String)("Expected path for tree item is:\n" + this.printFormattedStringArray((String[])expectedPath) + "\nReturned path is:\n" + this.printFormattedStringArray((String[])path)));
        }
    }

    @Test
    public void testGetCell() {
        this.createTreeItems((Tree)this.tree.getSWTWidget());
        DefaultTreeItem dfi = new DefaultTreeItem(new String[]{"A", "AA", "AAA"});
        String cellLabel = dfi.getCell(0);
        Assert.assertTrue((String)("Cell [0] of tree item has to be AAA but is " + cellLabel), (boolean)cellLabel.equals("AAA"));
        cellLabel = dfi.getCell(1);
        Assert.assertTrue((String)("Cell [1] of tree item has to be empty but is" + cellLabel), (cellLabel.length() == 0 ? 1 : 0) != 0);
    }

    private String printFormattedStringArray(String[] array) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            sb.append(item);
            sb.append(",");
            ++n2;
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    @Test
    public void testDynamicExpand() {
        this.createDynamicTreeItems((Tree)this.tree.getSWTWidget(), 2000, 1000, 5);
        DefaultTreeItem dfi = new DefaultTreeItem(new String[]{"A"});
        if (dfi.isExpanded()) {
            dfi.collapse();
        }
        int expectedNumItems = 3;
        dfi.expand(expectedNumItems, TimePeriod.getCustom((long)10L));
        int numItems = dfi.getItems().size();
        Assert.assertTrue((String)("Tree Item " + dfi.getText() + " has to have " + expectedNumItems + " but has " + numItems), (numItems >= expectedNumItems ? 1 : 0) != 0);
        if (this.generateDynamicTreeItems != null) {
            this.generateDynamicTreeItems.interrupt();
        }
        this.createDynamicTreeItems((Tree)this.tree.getSWTWidget(), 2000, 1000, 5);
        dfi = new DefaultTreeItem(new String[]{"A"});
        if (dfi.isExpanded()) {
            dfi.collapse();
        }
        boolean wasException = false;
        try {
            dfi.expand(expectedNumItems, TimePeriod.getCustom((long)3L));
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            wasException = true;
        }
        Assert.assertTrue((String)"WaitTimeoutExpiredException was not thrown", (boolean)wasException);
    }

    private void createDynamicTreeItems(final Tree tree, final int initSleep, final int delay, final int count) {
        this.removeTreeItems(tree);
        this.createTreeItem(tree, "A");
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                tree.addTreeListener(new TreeListener(){

                    public void treeExpanded(TreeEvent arg0) {
                        DefaultTreeItemTest.this.addDynamicTreeItems((TreeItem)arg0.item, initSleep, delay, count);
                    }

                    public void treeCollapsed(TreeEvent arg0) {
                    }
                });
            }
        });
    }

    private void addDynamicTreeItems(final TreeItem tiExpanded, final int initSleep, final int delay, final int count) {
        if (!this.isThreadAlreadyRunning()) {
            this.setThreadAlreadyRunning(true);
            this.generateDynamicTreeItems = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(initSleep);
                        int index = 0;
                        while (index < count) {
                            Thread.sleep(delay);
                            final String itemLabel = "A" + index;
                            if (Display.getDisplay() != null) {
                                Display.syncExec((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        TreeItem item = new TreeItem(tiExpanded, 0);
                                        item.setText(itemLabel);
                                        if (itemLabel.equals("A0")) {
                                            tiExpanded.setExpanded(true);
                                        }
                                    }
                                });
                            }
                            ++index;
                        }
                        DefaultTreeItemTest.this.setThreadAlreadyRunning(false);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            this.generateDynamicTreeItems.start();
        }
    }

    private boolean isThreadAlreadyRunning() {
        return this.threadAlreadyRunning;
    }

    private synchronized void setThreadAlreadyRunning(boolean threadAlreadyRunning) {
        this.threadAlreadyRunning = threadAlreadyRunning;
    }

    @After
    public void cleanUp() {
        if (this.generateDynamicTreeItems != null) {
            this.generateDynamicTreeItems.interrupt();
        }
    }
}

