/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.util.zip.ZipFacade;
import org.apache.maven.index.util.zip.ZipHandle;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactContext.class);
    private final File pom;
    private final File artifact;
    private final File metadata;
    private final ArtifactInfo artifactInfo;
    private final Gav gav;
    private final List<Exception> errors = new ArrayList<Exception>();

    public ArtifactContext(File pom, File artifact, File metadata, ArtifactInfo artifactInfo, Gav gav) throws IllegalArgumentException {
        if (artifactInfo == null) {
            throw new IllegalArgumentException("Parameter artifactInfo must not be null.");
        }
        this.pom = pom;
        this.artifact = artifact;
        this.metadata = metadata;
        this.artifactInfo = artifactInfo;
        this.gav = gav == null ? artifactInfo.calculateGav() : gav;
    }

    public File getPom() {
        return this.pom;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Model getPomModel() {
        block47: {
            File pom = this.getPom();
            if (pom != null && pom.isFile()) {
                try (InputStream inputStream = Files.newInputStream(pom.toPath(), new OpenOption[0]);){
                    Model model = new MavenXpp3Reader().read(inputStream, false);
                    return model;
                }
                catch (IOException | XmlPullParserException e) {
                    LOGGER.warn("skip error reading pom: " + pom, e);
                }
            } else if (this.getArtifact() != null && this.getArtifact().isFile()) {
                File artifact = this.getArtifact();
                try {
                    Throwable throwable = null;
                    try (ZipHandle handle = ZipFacade.getZipHandle((File)artifact);){
                        String embeddedPomPath = "META-INF/maven/" + this.getGav().getGroupId() + "/" + this.getGav().getArtifactId() + "/pom.xml";
                        if (handle.hasEntry(embeddedPomPath)) {
                            try (InputStream inputStream = handle.getEntryContent(embeddedPomPath);){
                                Model model = new MavenXpp3Reader().read(inputStream, false);
                                return model;
                            }
                        }
                        break block47;
                        {
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                throw throwable3;
                            }
                        }
                    }
                }
                catch (IOException | XmlPullParserException e) {
                    LOGGER.warn("skip error reading pom withing artifact:" + artifact, e);
                }
            }
        }
        return null;
    }

    public File getArtifact() {
        return this.artifact;
    }

    public File getMetadata() {
        return this.metadata;
    }

    public ArtifactInfo getArtifactInfo() {
        return this.artifactInfo;
    }

    public Gav getGav() {
        return this.gav;
    }

    public List<Exception> getErrors() {
        return this.errors;
    }

    public void addError(Exception e) {
        this.errors.add(e);
    }

    public Document createDocument(IndexingContext context) {
        Document doc = new Document();
        doc.add((IndexableField)new Field(ArtifactInfo.UINFO, this.getArtifactInfo().getUinfo(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((IndexableField)new Field(ArtifactInfo.LAST_MODIFIED, Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NO));
        for (IndexCreator indexCreator : context.getIndexCreators()) {
            try {
                indexCreator.populateArtifactInfo(this);
            }
            catch (IOException ex) {
                this.addError(ex);
            }
        }
        for (IndexCreator indexCreator : context.getIndexCreators()) {
            indexCreator.updateDocument(this.getArtifactInfo(), doc);
        }
        return doc;
    }
}

