/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.junit.launcher;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.JUnitLaunchConfiguration;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.JUnitLaunchConfigurationTab;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.LaunchConfiguration;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.RunConfigurationsDialog;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public class JUnitLaunchConfigurationTabTest {
    private static final String CONFIGURATION_NAME = JUnitLaunchConfigurationTabTest.class + "_test_config";
    protected LaunchConfigurationsDialog dialog;

    @Before
    public void openDialog() {
        this.dialog = new RunConfigurationsDialog();
        this.dialog.open();
    }

    @After
    public void closeDialog() {
        try {
            new WaitUntil((WaitCondition)new ShellIsAvailable(this.dialog.getTitle()), TimePeriod.NONE);
            new DefaultShell(this.dialog.getTitle()).close();
        }
        catch (RedDeerException redDeerException) {}
    }

    @Test
    public void testJUnitTab() {
        this.dialog.create((LaunchConfiguration)new JUnitLaunchConfiguration(), CONFIGURATION_NAME);
        JUnitLaunchConfigurationTab tab = new JUnitLaunchConfigurationTab();
        tab.activate();
        tab.setProject("abc");
        MatcherAssert.assertThat((Object)tab.getProject(), (Matcher)CoreMatchers.is((Object)"abc"));
        tab.setTestClass("cde");
        MatcherAssert.assertThat((Object)tab.getTestClass(), (Matcher)CoreMatchers.is((Object)"cde"));
        tab.setTestMethod("efg");
        MatcherAssert.assertThat((Object)tab.getTestMethod(), (Matcher)CoreMatchers.is((Object)"efg"));
    }
}

