/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.ui.dialogs;

import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassCreationWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.condition.ShellIsActive;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.condition.EditorWithTitleIsActive;
import org.eclipse.reddeer.workbench.impl.editor.TextEditor;
import org.eclipse.reddeer.workbench.impl.shell.WorkbenchShell;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public class OpenTypeSelectionDialogTest {
    private static final String TEST_PROJECT_NAME = "OpenTypeSelectionDialogTest";
    private static final String TEST_CLASS_NAME = "FindMe";

    @Test
    public void openTest() {
        OpenTypeSelectionDialog dialog = new OpenTypeSelectionDialog();
        dialog.open();
        Assert.assertTrue((String)"Shell 'Open Type' is not available", (boolean)new ShellIsActive("Open Type").test());
        dialog.cancel();
        Assert.assertFalse((String)"Shell 'Open Type' should be closed", (boolean)new ShellIsActive("Open Type").test());
    }

    @Test
    public void constructorTakingShellTest() {
        new ShellMenuItem((Shell)new WorkbenchShell(), new String[]{"Navigate", "Open Type..."}).select();
        DefaultShell shell = new DefaultShell("Open Type");
        OpenTypeSelectionDialog dialog = new OpenTypeSelectionDialog((Shell)shell);
        Assert.assertNotNull((Object)dialog.getShell());
        dialog.cancel();
        Assert.assertFalse((String)"Shell 'Open Type' should be closed", (boolean)new ShellIsActive("Open Type").test());
    }

    @Test
    public void nonParametericConstructorTest() {
        new ShellMenuItem((Shell)new WorkbenchShell(), new String[]{"Navigate", "Open Type..."}).select();
        OpenTypeSelectionDialog dialog = new OpenTypeSelectionDialog();
        Assert.assertNotNull((Object)dialog.getShell());
        dialog.cancel();
        Assert.assertFalse((String)"Shell 'Open Type' should be closed", (boolean)new ShellIsActive("Open Type").test());
    }

    @Test
    public void findAndOpenClass() {
        OpenTypeSelectionDialog dialog = new OpenTypeSelectionDialog();
        dialog.open();
        dialog.setFilterText(TEST_CLASS_NAME);
        List items = dialog.getResultsTable().getItems();
        Assert.assertEquals((String)"There should be one item in 'Open Type' dialog.", (long)1L, (long)items.size());
        Assert.assertTrue((String)"The 'Open Type' dialog should find 'FindMe' class.", (boolean)((TableItem)items.get(0)).getText().contains(TEST_CLASS_NAME));
        dialog.ok();
        Assert.assertFalse((String)"Shell 'Open Type' should be closed", (boolean)new ShellIsActive("Open Type").test());
        try {
            new TextEditor("FindMe.java");
        }
        catch (RedDeerException redDeerException) {
            Assert.fail((String)"Editor FindMe.java is unavailable.");
        }
    }

    @BeforeClass
    public static void prepareWorkspace() {
        OpenTypeSelectionDialogTest.createJavaProject(TEST_PROJECT_NAME);
        OpenTypeSelectionDialogTest.createJavaClass(TEST_CLASS_NAME);
        new WaitUntil((WaitCondition)new EditorWithTitleIsActive("FindMe.java"));
        new TextEditor("FindMe.java").close();
    }

    @AfterClass
    public static void cleanWorkspace() {
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        pe.deleteAllProjects();
    }

    private static void createJavaProject(String name) {
        JavaProjectWizard javaProject = new JavaProjectWizard();
        javaProject.open();
        NewJavaProjectWizardPageOne javaWizardPage = new NewJavaProjectWizardPageOne((ReferencedComposite)javaProject);
        javaWizardPage.setProjectName(name);
        javaProject.finish();
    }

    private static void createJavaClass(String name) {
        NewClassCreationWizard javaClassDialog = new NewClassCreationWizard();
        javaClassDialog.open();
        NewClassWizardPage wizardPage = new NewClassWizardPage((ReferencedComposite)javaClassDialog);
        wizardPage.setName(name);
        if (wizardPage.getSourceFolder().isEmpty()) {
            wizardPage.setSourceFolder("OpenTypeSelectionDialogTest/src");
        }
        wizardPage.setPackage("test");
        javaClassDialog.finish();
    }
}

