/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.ui.packageexplorer;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.core.lookup.WorkbenchPartLookup;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class PackageExplorerTest {
    private static final String PROJECT_NAME_0 = "PackageExplorerTestProject0";
    private static final String PROJECT_NAME_1 = "PackageExplorerTestProject1";
    private static final String PROJECT_NAME_2 = "PackageExplorerTestProject2";
    private static final String PROJECT_NAME_3 = "PackageExplorerTestProject3";
    private static PackageExplorerPart packageExplorer;
    private static DefaultProject project0;
    private static DefaultProject project1;
    private static DefaultProject project2;

    @BeforeClass
    public static void setUp() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        NewJavaProjectWizardPageOne page1 = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        page1.setProjectName(PROJECT_NAME_0);
        dialog.finish();
        dialog = new JavaProjectWizard();
        dialog.open();
        page1 = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        page1.setProjectName(PROJECT_NAME_1);
        dialog.finish();
        dialog = new JavaProjectWizard();
        dialog.open();
        page1 = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        page1.setProjectName(PROJECT_NAME_2);
        dialog.finish();
        packageExplorer = new PackageExplorerPart();
        packageExplorer.open();
        project0 = packageExplorer.getProject(PROJECT_NAME_0);
        project1 = packageExplorer.getProject(PROJECT_NAME_1);
        project2 = packageExplorer.getProject(PROJECT_NAME_2);
        project1.select();
    }

    @Test
    public void open() {
        packageExplorer = new PackageExplorerPart();
        packageExplorer.open();
        String currentViewTitle = WorkbenchPartLookup.getInstance().getActiveWorkbenchPartTitle();
        Assert.assertTrue((String)("Active View has to be Package Explorer but is " + currentViewTitle), (boolean)currentViewTitle.equals("Package Explorer"));
    }

    @Test
    public void select() {
        project1.select();
        Assert.assertTrue((String)("Project " + project1.getName() + " is not selected"), (boolean)project1.isSelected());
        Assert.assertTrue((String)("Project " + project0.getName() + " is selected"), (!project0.isSelected() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Project " + project2.getName() + " is selected"), (!project2.isSelected() ? 1 : 0) != 0);
    }

    @Test
    public void multipleSelect() {
        packageExplorer.selectProjects(new String[]{PROJECT_NAME_0, PROJECT_NAME_2});
        Assert.assertTrue((String)("Project " + project0.getName() + " is not selected"), (boolean)project0.isSelected());
        Assert.assertTrue((String)("Project " + project1.getName() + " is selected"), (!project1.isSelected() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Project " + project2.getName() + " is not selected"), (boolean)project2.isSelected());
    }

    @Test
    public void delete() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        NewJavaProjectWizardPageOne page1 = new NewJavaProjectWizardPageOne((ReferencedComposite)dialog);
        page1.setProjectName(PROJECT_NAME_3);
        dialog.finish();
        packageExplorer.getProject(PROJECT_NAME_3).delete(true);
        Assert.assertFalse((String)"Package Explorer contains project PackageExplorerTestProject3 but it should be deleted.", (boolean)packageExplorer.containsProject(PROJECT_NAME_3));
    }

    @Test
    public void getTitle() {
        packageExplorer = new PackageExplorerPart();
        packageExplorer.open();
        String pacakgeExplorerTitle = packageExplorer.getTitle();
        Assert.assertTrue((String)("Package Explorer has wrong title: '" + pacakgeExplorerTitle + "'"), (boolean)pacakgeExplorerTitle.equals("Package Explorer"));
    }

    @AfterClass
    public static void tearDown() {
        if (packageExplorer != null) {
            for (DefaultProject p : packageExplorer.getProjects()) {
                DeleteUtils.forceProjectDeletion((DefaultProject)p, (boolean)true);
            }
        }
    }
}

