/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.wizards.newresource;

import java.io.File;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.reddeer.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.reddeer.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizardFirstPage;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class BasicNewProjectResourceWizardTest {
    private static final String DEFAULT_PROJECT_NAME = "defaultGeneralProject";
    private static final String CUSTOMIZED_PROJECT_NAME = "customizedGeneralProject";
    private PackageExplorerPart packageExplorer;
    private static final String CUSTOM_PROJECT_LOCATION = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "rdcustomprojectlocation" + System.currentTimeMillis();

    @Before
    public void setUp() {
        this.packageExplorer = new PackageExplorerPart();
    }

    @Test
    public void createGeneralProjectsWithReferences() {
        this.packageExplorer.open();
        BasicNewProjectResourceWizard wizardDialog = new BasicNewProjectResourceWizard();
        wizardDialog.open();
        BasicNewProjectResourceWizardFirstPage projectPage = new BasicNewProjectResourceWizardFirstPage((ReferencedComposite)wizardDialog);
        projectPage.setProjectName(DEFAULT_PROJECT_NAME);
        wizardDialog.finish();
        wizardDialog.open();
        projectPage.setProjectName(CUSTOMIZED_PROJECT_NAME);
        File customProjectDir = new File(CUSTOM_PROJECT_LOCATION);
        if (customProjectDir.exists()) {
            customProjectDir.delete();
        }
        customProjectDir.mkdir();
        projectPage.setProjectLocation(CUSTOM_PROJECT_LOCATION);
        try {
            projectPage.addProjectToWorkingSet("dummyws");
        }
        catch (EclipseLayerException eclipseLayerException) {}
        wizardDialog.next();
        new WizardNewProjectReferencePage((ReferencedComposite)wizardDialog).setProjectReferences(new String[]{DEFAULT_PROJECT_NAME});
        wizardDialog.finish();
        Assert.assertTrue((String)"Package Explorer has to contain project customizedGeneralProject but it doesn't", (boolean)this.packageExplorer.containsProject(CUSTOMIZED_PROJECT_NAME));
    }

    @Test
    public void createGeneralProjects() {
        BasicNewProjectResourceWizard wizardDialog = new BasicNewProjectResourceWizard();
        wizardDialog.open();
        BasicNewProjectResourceWizardFirstPage projectPage = new BasicNewProjectResourceWizardFirstPage((ReferencedComposite)wizardDialog);
        projectPage.setProjectName(DEFAULT_PROJECT_NAME);
        wizardDialog.finish();
        this.packageExplorer.open();
        Assert.assertTrue((String)"Package Explorer has to contain project defaultGeneralProject but it doesn't", (boolean)this.packageExplorer.containsProject(DEFAULT_PROJECT_NAME));
    }

    @After
    public void tearDown() {
        File customProjectDir;
        this.packageExplorer.open();
        if (this.packageExplorer.containsProject(CUSTOMIZED_PROJECT_NAME)) {
            DeleteUtils.forceProjectDeletion((DefaultProject)this.packageExplorer.getProject(CUSTOMIZED_PROJECT_NAME), (boolean)true);
        }
        if (this.packageExplorer.containsProject(DEFAULT_PROJECT_NAME)) {
            DeleteUtils.forceProjectDeletion((DefaultProject)this.packageExplorer.getProject(DEFAULT_PROJECT_NAME), (boolean)true);
        }
        if ((customProjectDir = new File(CUSTOM_PROJECT_LOCATION)).exists()) {
            customProjectDir.delete();
        }
    }
}

