/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.server.ui;

import java.util.List;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.wst.server.ui.Runtime;
import org.eclipse.reddeer.eclipse.wst.server.ui.RuntimePreferencePage;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewRuntimeWizardDialog;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewRuntimeWizardPage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class RuntimePreferencePageTest {
    private static final String SERVER_NAME = "Test runtime";
    private static final String SERVER_NAME_2 = "Test runtime 2";
    private static final String SERVER_PATH = "Basic";
    private WorkbenchPreferenceDialog preferencesDialog;
    private RuntimePreferencePage preferencePage;

    @Before
    public void openPreference() {
        this.preferencesDialog = new WorkbenchPreferenceDialog();
        this.preferencePage = new RuntimePreferencePage((ReferencedComposite)this.preferencesDialog);
        this.preferencesDialog.open();
        this.preferencesDialog.select((PreferencePage)this.preferencePage);
        this.preferencePage.removeAllRuntimes();
    }

    @After
    public void closePreference() {
        this.preferencePage.removeAllRuntimes();
        this.preferencesDialog.cancel();
    }

    @Test
    public void addAndRemoveRuntime() {
        NewRuntimeWizardDialog wizardDialog = this.preferencePage.addRuntime();
        NewRuntimeWizardPage wizardPage = new NewRuntimeWizardPage((ReferencedComposite)wizardDialog);
        wizardPage.selectType(new String[]{SERVER_PATH, SERVER_NAME});
        wizardDialog.finish();
        wizardDialog = this.preferencePage.addRuntime();
        wizardPage = new NewRuntimeWizardPage((ReferencedComposite)wizardDialog);
        wizardPage.selectType(new String[]{SERVER_PATH, SERVER_NAME});
        wizardDialog.finish();
        List runtimes = this.preferencePage.getServerRuntimes();
        Assert.assertThat((Object)runtimes.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Runtime)runtimes.get(0)), (Matcher)CoreMatchers.is((Object)new Runtime(SERVER_NAME, SERVER_NAME)));
        Assert.assertThat((Object)((Runtime)runtimes.get(1)), (Matcher)CoreMatchers.is((Object)new Runtime("Test runtime (2)", SERVER_NAME)));
        this.preferencePage.removeRuntime(new Runtime("Test runtime (2)", null));
        runtimes = this.preferencePage.getServerRuntimes();
        Assert.assertThat((Object)runtimes.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Runtime)runtimes.get(0)), (Matcher)CoreMatchers.is((Object)new Runtime(SERVER_NAME, SERVER_NAME)));
        this.preferencePage.removeRuntime(new Runtime(SERVER_NAME, null));
        runtimes = this.preferencePage.getServerRuntimes();
        Assert.assertThat((Object)runtimes.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void removeAllRuntime() {
        NewRuntimeWizardDialog wizardDialog = this.preferencePage.addRuntime();
        NewRuntimeWizardPage wizardPage = new NewRuntimeWizardPage((ReferencedComposite)wizardDialog);
        wizardPage.selectType(new String[]{SERVER_PATH, SERVER_NAME});
        wizardDialog.finish();
        wizardDialog = this.preferencePage.addRuntime();
        wizardPage = new NewRuntimeWizardPage((ReferencedComposite)wizardDialog);
        wizardPage.selectType(new String[]{SERVER_PATH, SERVER_NAME});
        wizardDialog.finish();
        List runtimes = this.preferencePage.getServerRuntimes();
        Assert.assertThat((Object)runtimes.size(), (Matcher)CoreMatchers.is((Object)2));
        this.preferencePage.removeAllRuntimes();
        runtimes = this.preferencePage.getServerRuntimes();
        Assert.assertThat((Object)runtimes.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void editRuntime() {
        NewRuntimeWizardDialog wizardDialog = this.preferencePage.addRuntime();
        NewRuntimeWizardPage wizardPage = new NewRuntimeWizardPage((ReferencedComposite)wizardDialog);
        wizardPage.selectType(new String[]{SERVER_PATH, SERVER_NAME});
        wizardDialog.finish();
        Assert.assertFalse((boolean)new PushButton("Edit...").isEnabled());
    }

    @Test
    public void getServerRuntime() {
        NewRuntimeWizardDialog wizardDialog = this.preferencePage.addRuntime();
        NewRuntimeWizardPage wizardPage = new NewRuntimeWizardPage((ReferencedComposite)wizardDialog);
        wizardPage.selectType(new String[]{SERVER_PATH, SERVER_NAME});
        wizardDialog.finish();
        wizardDialog = this.preferencePage.addRuntime();
        wizardPage = new NewRuntimeWizardPage((ReferencedComposite)wizardDialog);
        wizardPage.selectType(new String[]{SERVER_PATH, SERVER_NAME_2});
        wizardDialog.finish();
        wizardDialog = this.preferencePage.addRuntime();
        wizardPage = new NewRuntimeWizardPage((ReferencedComposite)wizardDialog);
        wizardPage.selectType(new String[]{SERVER_PATH, SERVER_NAME_2});
        wizardDialog.finish();
        List runtimes = this.preferencePage.getServerRuntimes();
        Assert.assertThat((Object)runtimes.size(), (Matcher)CoreMatchers.is((Object)3));
        Runtime runtime1 = this.preferencePage.getServerRuntime(SERVER_NAME, SERVER_NAME);
        Assert.assertThat((Object)runtime1, (Matcher)CoreMatchers.is((Object)new Runtime(SERVER_NAME, SERVER_NAME)));
        Runtime runtime2 = this.preferencePage.getServerRuntime(new Runtime(SERVER_NAME_2, SERVER_NAME_2));
        Assert.assertThat((Object)runtime2, (Matcher)CoreMatchers.is((Object)new Runtime(SERVER_NAME_2, SERVER_NAME_2)));
        Runtime runtime3 = null;
        try {
            runtime3 = this.preferencePage.getServerRuntime(SERVER_NAME_2);
        }
        catch (EclipseLayerException exc) {
            Assert.fail((String)exc.getMessage());
        }
        Assert.assertThat((Object)runtime3, (Matcher)CoreMatchers.is((Object)new Runtime(SERVER_NAME_2, SERVER_NAME_2)));
    }
}

