/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.xml.ui.tabletree;

import java.io.File;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.test.Activator;
import org.eclipse.reddeer.eclipse.test.ui.part.MultiPageEditorTest;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizardDialog;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.WizardProjectsImportPage;
import org.eclipse.reddeer.eclipse.wst.xml.ui.tabletree.XMLDesignPage;
import org.eclipse.reddeer.eclipse.wst.xml.ui.tabletree.XMLMultiPageEditorPart;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class XMLDesignPageTest {
    public static final File ZIP_FILE = new File(Activator.getTestResourcesLocation(MultiPageEditorTest.class), "xml-project.zip");
    protected static final String PROJECT_NAME = "xml-project";
    protected static final String FILE_NAME = "file.xml";
    private static XMLDesignPage page;

    @BeforeClass
    public static void importProject() {
        ExternalProjectImportWizardDialog wizard = new ExternalProjectImportWizardDialog();
        wizard.open();
        WizardProjectsImportPage wizardPage = new WizardProjectsImportPage((ReferencedComposite)wizard);
        wizardPage.setArchiveFile(ZIP_FILE.getAbsolutePath());
        wizardPage.selectProjects(new String[]{PROJECT_NAME});
        wizard.finish();
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        explorer.getProject(PROJECT_NAME).getProjectItem(new String[]{FILE_NAME}).open();
        XMLMultiPageEditorPart editor = new XMLMultiPageEditorPart(FILE_NAME);
        page = editor.getDesignPage();
    }

    @AfterClass
    public static void cleanProject() {
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        explorer.getProject(PROJECT_NAME).delete(true);
    }

    @Test
    public void getNode() {
        MatcherAssert.assertThat((Object)page.getNode(new String[]{"a", "b1"}).getName(), (Matcher)CoreMatchers.is((Object)"b1"));
    }

    @Test
    public void getNode_childNode() {
        XMLDesignPage.XMLDesignPageNode node = page.getNode(new String[]{"a"});
        MatcherAssert.assertThat((Object)page.getNode(node, new String[]{"b1", "c"}).getName(), (Matcher)CoreMatchers.is((Object)"c"));
    }

    @Test
    public void getAttribute() {
        XMLDesignPage.XMLDesignPageNode node = page.getNode(new String[]{"a", "b1"});
        MatcherAssert.assertThat((Object)page.getAttributeValue(node, "y"), (Matcher)CoreMatchers.is((Object)"2"));
    }

    @Test
    public void getValue() {
        XMLDesignPage.XMLDesignPageNode node = page.getNode(new String[]{"a", "b1", "c"});
        MatcherAssert.assertThat((Object)page.getContent(node), (Matcher)CoreMatchers.is((Object)"content"));
    }
}

