/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.xml.ui.tabletree;

import java.io.File;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.test.Activator;
import org.eclipse.reddeer.eclipse.test.ui.part.MultiPageEditorTest;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizardDialog;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.WizardProjectsImportPage;
import org.eclipse.reddeer.eclipse.wst.xml.ui.tabletree.XMLEditorFile;
import org.eclipse.reddeer.eclipse.wst.xml.ui.tabletree.XMLMultiPageEditorPart;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.styledtext.DefaultStyledText;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class XMLMultiPageEditorTest {
    public static final File ZIP_FILE = new File(Activator.getTestResourcesLocation(MultiPageEditorTest.class), "xml-project.zip");
    protected static final String PROJECT_NAME = "xml-project";
    protected static final String FILE_NAME = "file.xml";
    private static XMLMultiPageEditorPart editor;

    @BeforeClass
    public static void importProject() {
        ExternalProjectImportWizardDialog wizard = new ExternalProjectImportWizardDialog();
        wizard.open();
        WizardProjectsImportPage wizardPage = new WizardProjectsImportPage((ReferencedComposite)wizard);
        wizardPage.setArchiveFile(ZIP_FILE.getAbsolutePath());
        wizardPage.selectProjects(new String[]{PROJECT_NAME});
        wizard.finish();
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        explorer.getProject(PROJECT_NAME).getProjectItem(new String[]{FILE_NAME}).open();
        editor = new XMLMultiPageEditorPart(FILE_NAME);
    }

    @AfterClass
    public static void cleanProject() {
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        explorer.getProject(PROJECT_NAME).delete(true);
    }

    @Test
    public void selectDesignPage() {
        editor.selectDesignPage();
        new DefaultTreeItem(new String[]{"a", "b1"});
    }

    @Test
    public void selectSourcePage() {
        editor.selectSourcePage();
        Assert.assertTrue((boolean)new DefaultStyledText().getText().contains("</a>"));
    }

    @Test
    public void getDesignPage() {
        editor.selectSourcePage();
        MatcherAssert.assertThat((Object)editor.getDesignPage().getNode(new String[]{"a", "b1"}).getName(), (Matcher)CoreMatchers.is((Object)"b1"));
    }

    @Test
    public void getSourcePage() {
        editor.selectDesignPage();
        Assert.assertTrue((boolean)editor.getSourcePage().getText().contains("</a>"));
    }

    @Test
    public void testGettingingAssociatedXMLEditorFile() {
        XMLEditorFile xmlEditorFile = editor.getAssociatedFile();
        Assert.assertEquals((Object)"/xml-project/file.xml", (Object)xmlEditorFile.getRelativePath());
    }

    @Test
    public void testEvaluatingXPathOnAssociatedXMLEditorFile() {
        XMLEditorFile xmlEditorFile = editor.getAssociatedFile();
        Assert.assertEquals((Object)"4", (Object)xmlEditorFile.xpath("/a/b1[2]/@y"));
    }
}

