/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.integration.test.installation.common.page;

import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.integration.test.installation.common.page.ValidatedWizardPage;
import org.eclipse.reddeer.jface.dialogs.TitleAreaDialog;
import org.eclipse.reddeer.swt.impl.button.RadioButton;
import org.eclipse.reddeer.swt.impl.styledtext.DefaultStyledText;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.hamcrest.Matcher;

public class RemediationActionPage
extends ValidatedWizardPage {
    public static final String PAGE_TITLE = "(.*Remediation Page)|(Confirm Selected Features)";
    public static final String RADIO_KEEP_MY_INSTALL = "Keep my installation the same and modify the items being installed to be compatible";
    public static final String RADIO_UPDATE_MY_INSTALL = "Update my installation to be compatible with the items being installed";
    public static final String RADIO_SHOW_ORIGINAL_ERRORS = "Show original error and build my own solution:";

    public RemediationActionPage(TitleAreaDialog installDialog) {
        super(installDialog, (Matcher<?>)new WithTextMatcher((Matcher)new RegexMatcher(PAGE_TITLE)));
    }

    public void chooseKeepMyInstallation() {
        new RadioButton(this.referencedComposite, RADIO_KEEP_MY_INSTALL).click();
    }

    public void chooseUpdateMyInstallation() {
        new RadioButton(this.referencedComposite, RADIO_UPDATE_MY_INSTALL).click();
    }

    public void chooseShowOriginalErrors() {
        new RadioButton(this.referencedComposite, RADIO_SHOW_ORIGINAL_ERRORS).click();
    }

    public boolean isEnabledKeepMyInstallation() {
        return new RadioButton(this.referencedComposite, RADIO_KEEP_MY_INSTALL).isEnabled();
    }

    public boolean isEnabledUpdateMyInstallation() {
        return new RadioButton(this.referencedComposite, RADIO_UPDATE_MY_INSTALL).isEnabled();
    }

    public boolean isEnabledShowOriginalErrors() {
        return new RadioButton(this.referencedComposite, RADIO_SHOW_ORIGINAL_ERRORS).isEnabled();
    }

    public String getOriginalError() {
        this.chooseShowOriginalErrors();
        try {
            return new DefaultStyledText(this.referencedComposite).getText();
        }
        catch (CoreLayerException coreLayerException) {
            return new DefaultText(this.referencedComposite).getText();
        }
    }

    public DefaultTree getSolutionsDetailsTree() {
        if (this.isEnabledUpdateMyInstallation() || this.isEnabledKeepMyInstallation()) {
            return new DefaultTree((ReferencedComposite)this);
        }
        throw new IllegalStateException("Solution Details Tree is available only if either 'Keep...' or 'Update...' is selected.");
    }
}

