/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.integration.runner.order.testcase;

import java.util.List;
import org.eclipse.reddeer.junit.internal.configuration.SuiteConfiguration;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.junit.test.integration.runner.order.RequirementsOrderRunnerSuite;
import org.eclipse.reddeer.junit.test.integration.runner.order.TestSequence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

@RunWith(value=RedDeerSuite.class)
public class RequirementOrderCallWithFailsTest {
    @Before
    public void setupSequence() {
        TestSequence.getRealSequence().clear();
    }

    @Test
    public void testPassingTest() throws InitializationError {
        SuiteConfiguration config = new SuiteConfiguration(RequirementsOrderRunnerSuite.RequirementOrderPassedTest.class);
        List runners = RedDeerSuite.createSuites(RequirementsOrderRunnerSuite.RequirementOrderPassedTest.class, (SuiteConfiguration)config);
        Runner myRunner = (Runner)runners.get(0);
        RunNotifier notifier = new RunNotifier();
        myRunner.run(notifier);
        String sequenceDiff = TestSequence.diffRealSequence(RequirementsOrderRunnerSuite.getStaticExpectedSequence());
        Assert.assertTrue((String)("Test sequence is different than expected. " + sequenceDiff), (sequenceDiff == null ? 1 : 0) != 0);
    }

    @Test
    public void testFailingTest() throws InitializationError {
        SuiteConfiguration config = new SuiteConfiguration(RequirementsOrderRunnerSuite.RequirementOrderFailedTest.class);
        List runners = RedDeerSuite.createSuites(RequirementsOrderRunnerSuite.RequirementOrderFailedTest.class, (SuiteConfiguration)config);
        Runner myRunner = (Runner)runners.get(0);
        RunNotifier notifier = new RunNotifier();
        myRunner.run(notifier);
        String sequenceDiff = TestSequence.diffRealSequence(RequirementsOrderRunnerSuite.getStaticExpectedSequence());
        Assert.assertTrue((String)("Test sequence is different than expected. " + sequenceDiff), (sequenceDiff == null ? 1 : 0) != 0);
    }

    @Test
    public void testErroneousTest() throws InitializationError {
        SuiteConfiguration config = new SuiteConfiguration(RequirementsOrderRunnerSuite.RequirementOrderErroneousTest.class);
        List runners = RedDeerSuite.createSuites(RequirementsOrderRunnerSuite.RequirementOrderErroneousTest.class, (SuiteConfiguration)config);
        Runner myRunner = (Runner)runners.get(0);
        RunNotifier notifier = new RunNotifier();
        myRunner.run(notifier);
        String sequenceDiff = TestSequence.diffRealSequence(RequirementsOrderRunnerSuite.getStaticExpectedSequence());
        Assert.assertTrue((String)("Test sequence is different than expected. " + sequenceDiff), (sequenceDiff == null ? 1 : 0) != 0);
    }

    @After
    public void clearSequence() {
        TestSequence.getRealSequence().clear();
    }
}

