/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.logparser.model;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.reddeer.logparser.LogParserActivator;
import org.eclipse.reddeer.logparser.LogParserLog;
import org.eclipse.reddeer.logparser.model.LogData;
import org.eclipse.reddeer.logparser.model.ParseRule;
import org.eclipse.reddeer.logparser.preferences.LogParserPreferencesPageModel;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class LogParserDataModel {
    private static final String TAG_LOGS = "logs";
    private static final String TAG_LOG_DATA = "log_data";
    private static final String TAG_LOCATION = "location";
    private static final String TAG_RULE_NAME = "rule_name";

    public static ArrayList<LogData> getLogParserData() {
        return LogParserDataModel.loadLogParserData();
    }

    public static void saveLogParserData(List<LogData> logs) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_LOGS);
        OutputStreamWriter fileWriter = null;
        try {
            try {
                for (LogData logData : logs) {
                    IMemento logDataNode = memento.createChild(TAG_LOG_DATA);
                    logDataNode.putString(TAG_LOCATION, logData.getLocation());
                    for (ParseRule parseRule : logData.getParseRules()) {
                        logDataNode.createChild(TAG_RULE_NAME).putTextData(parseRule.getName());
                    }
                }
                fileWriter = new FileWriter(LogParserDataModel.getLogParserFile());
                memento.save((Writer)fileWriter);
            }
            catch (IOException ioe) {
                LogParserLog.logError(ioe);
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException ioe2) {
                    LogParserLog.logError(ioe2);
                }
            }
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException ioe) {
                LogParserLog.logError(ioe);
            }
        }
    }

    private static ArrayList<LogData> loadLogParserData() {
        ArrayList<LogData> logs = new ArrayList<LogData>();
        FileReader fileReader = null;
        File logParserFile = LogParserDataModel.getLogParserFile();
        ArrayList<ParseRule> definedParseRules = LogParserPreferencesPageModel.getParseRules();
        if (logParserFile.exists()) {
            try {
                try {
                    IMemento[] logDataNodes;
                    fileReader = new FileReader(logParserFile);
                    IMemento[] iMementoArray = logDataNodes = XMLMemento.createReadRoot((Reader)fileReader).getChildren(TAG_LOG_DATA);
                    int n = logDataNodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento[] parseRuleNodes;
                        IMemento logDataNode = iMementoArray[n2];
                        LogData logData = new LogData();
                        logData.setLocation(logDataNode.getString(TAG_LOCATION));
                        ArrayList<ParseRule> parseRules = new ArrayList<ParseRule>();
                        IMemento[] iMementoArray2 = parseRuleNodes = logDataNode.getChildren(TAG_RULE_NAME);
                        int n3 = parseRuleNodes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemento parseRuleNode = iMementoArray2[n4];
                            ParseRule parseRule = LogParserDataModel.getRuleByName(parseRuleNode.getTextData(), definedParseRules);
                            if (parseRule != null) {
                                parseRules.add(parseRule);
                            }
                            ++n4;
                        }
                        logData.setParseRules(parseRules);
                        logs.add(logData);
                        ++n2;
                    }
                }
                catch (IOException | WorkbenchException ioe) {
                    LogParserLog.logError(ioe);
                    try {
                        if (fileReader != null) {
                            fileReader.close();
                        }
                    }
                    catch (IOException ioe2) {
                        LogParserLog.logError(ioe2);
                    }
                }
            }
            finally {
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException ioe) {
                    LogParserLog.logError(ioe);
                }
            }
        }
        return logs;
    }

    private static File getLogParserFile() {
        return LogParserActivator.getDefault().getStateLocation().append("logparserdata.xml").toFile();
    }

    public static ParseRule getRuleByName(String name, List<ParseRule> parseRules) {
        ParseRule parseRule = null;
        if (parseRules != null && name != null) {
            Iterator<ParseRule> itParseRule = parseRules.iterator();
            while (parseRule == null && itParseRule.hasNext()) {
                ParseRule currentParseRule = itParseRule.next();
                if (!name.equalsIgnoreCase(currentParseRule.getName())) continue;
                parseRule = currentParseRule;
            }
        }
        return parseRule;
    }
}

