/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.button;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.swt.impl.button.BackButton;
import org.eclipse.reddeer.swt.impl.button.CancelButton;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.button.NextButton;
import org.eclipse.reddeer.swt.impl.button.NoButton;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.YesButton;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class PredefinedButtonTest
extends SWTLayerTestCase {
    private SelectionListener selectionListener;
    private org.eclipse.reddeer.swt.api.Text selectionText = null;
    private static int ROW_COUNT = 4;
    private String[] OK_BUTTON = new String[]{"&OK", "Ok", "ok", "oK"};
    private String[] CANCEL_BUTTON = new String[]{"&Cancel", "CANCEL", "cancel", "cANCEL"};
    private String[] YES_BUTTON = new String[]{"&Yes", "YES", "yes", "yES"};
    private String[] NO_BUTTON = new String[]{"&No", "NO", "no", "no"};
    private String[] NEXT_BUTTON = new String[]{"&Next >", "NEXT", "next", "nEXT"};
    private String[] BACK_BUTTON = new String[]{"< &Back", "BACK", "back", "bACK"};
    private String[] FINISH_BUTTON = new String[]{"&Finish", "FINISH", "finish", "fINISH"};
    private List<Button> buttons = new ArrayList<Button>();
    private Text txSelection;

    @Override
    protected void createControls(Shell shell) {
        shell.setLayout((Layout)new GridLayout(ROW_COUNT, true));
        this.selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                Button selectedButton = (Button)arg0.widget;
                PredefinedButtonTest.this.txSelection.setText(selectedButton.getData().toString());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        this.createButtons(this.OK_BUTTON, 8, shell);
        this.createButtons(this.CANCEL_BUTTON, 8, shell);
        this.createButtons(this.YES_BUTTON, 8, shell);
        this.createButtons(this.NO_BUTTON, 8, shell);
        this.createButtons(this.NEXT_BUTTON, 8, shell);
        this.createButtons(this.BACK_BUTTON, 8, shell);
        this.createButtons(this.FINISH_BUTTON, 8, shell);
        this.txSelection = new Text((Composite)shell, 2048);
        this.txSelection.setText("<text of selected button>");
    }

    private org.eclipse.reddeer.swt.api.Text getSelectionText() {
        if (this.selectionText == null) {
            this.selectionText = new DefaultText(0, new Matcher[0]);
        }
        return this.selectionText;
    }

    private void createButtons(String[] text, int style, Shell shell) {
        int i = 0;
        while (i < ROW_COUNT) {
            Button button = new Button((Composite)shell, style);
            button.setText(text[i]);
            button.setToolTipText(text[i]);
            button.setData((Object)text[i]);
            button.addSelectionListener(this.selectionListener);
            this.buttons.add(button);
            ++i;
        }
    }

    @Test(expected=CoreLayerException.class)
    public void testPrescribedButtonsNotFound() {
        this.visibleButtons(false);
        new OkButton();
    }

    @Test
    public void testPresribedButtonsFound() {
        this.visibleButtons(true);
        OkButton okButton = new OkButton();
        okButton.click();
        Assert.assertEquals((Object)this.getSelectionText().getText(), (Object)this.OK_BUTTON[0]);
        CancelButton cancelButton = new CancelButton();
        cancelButton.click();
        Assert.assertEquals((Object)this.getSelectionText().getText(), (Object)this.CANCEL_BUTTON[0]);
        NextButton nextButton = new NextButton();
        nextButton.click();
        Assert.assertEquals((Object)this.getSelectionText().getText(), (Object)this.NEXT_BUTTON[0]);
        BackButton backButton = new BackButton();
        backButton.click();
        Assert.assertEquals((Object)this.getSelectionText().getText(), (Object)this.BACK_BUTTON[0]);
        YesButton yesButton = new YesButton();
        yesButton.click();
        Assert.assertEquals((Object)this.getSelectionText().getText(), (Object)this.YES_BUTTON[0]);
        NoButton noButton = new NoButton();
        noButton.click();
        Assert.assertEquals((Object)this.getSelectionText().getText(), (Object)this.NO_BUTTON[0]);
        FinishButton finishButton = new FinishButton();
        finishButton.click();
        Assert.assertEquals((Object)this.getSelectionText().getText(), (Object)this.FINISH_BUTTON[0]);
    }

    private void visibleButtons(final boolean enable) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                for (Button b : PredefinedButtonTest.this.buttons) {
                    b.setVisible(enable);
                }
            }
        });
    }
}

