/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.combo;

import java.util.Arrays;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.WithIdMatcher;
import org.eclipse.reddeer.swt.api.Combo;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.combo.LabeledCombo;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.reddeer.swt.test.utils.LabelTestUtils;
import org.eclipse.reddeer.swt.test.utils.TextTestUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ComboTest
extends SWTLayerTestCase {
    private static final String COMBO_TEST_KEY = "comboTestKey";
    private static final String COMBO_LABEL_PREFIX = "Combo";
    private static final String COMBO_ITEM_PREFIX = "Item";
    private static final String DISABLED_COMBO_LABEL = "Disabled:";

    @Override
    protected void createControls(Shell shell) {
        LabelTestUtils.createLabel((Composite)shell, "Last selection:");
        final Text selectionText = TextTestUtils.createText((Composite)shell, "No selection yet");
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                selectionText.setText(((org.eclipse.swt.widgets.Combo)e.widget).getText());
            }
        };
        int comboIndex = 0;
        while (comboIndex < 4) {
            LabelTestUtils.createLabel((Composite)shell, COMBO_LABEL_PREFIX + comboIndex);
            this.createCombo(shell, selectionListener, comboIndex);
            ++comboIndex;
        }
        LabelTestUtils.createLabel((Composite)shell, DISABLED_COMBO_LABEL);
        org.eclipse.swt.widgets.Combo combo = new org.eclipse.swt.widgets.Combo((Composite)shell, 2048);
        combo.setEnabled(false);
    }

    private void createCombo(Shell shell, SelectionAdapter selectionListener, int comboIndex) {
        org.eclipse.swt.widgets.Combo combo = new org.eclipse.swt.widgets.Combo((Composite)shell, 2048);
        combo.addSelectionListener((SelectionListener)selectionListener);
        String[] comboItems = this.createSampleComboItems(comboIndex);
        int itemIndex = 0;
        while (itemIndex < comboItems.length) {
            combo.add(comboItems[itemIndex]);
            ++itemIndex;
        }
        combo.setData(COMBO_TEST_KEY, (Object)comboIndex);
    }

    private String[] createSampleComboItems(int comboIndex) {
        String[] items = new String[4];
        int i = 0;
        while (i < 4) {
            items[i] = COMBO_ITEM_PREFIX + comboIndex + i;
            ++i;
        }
        return items;
    }

    @Test
    public void findByIndex() {
        int index = 1;
        DefaultCombo combo = new DefaultCombo(index, new Matcher[0]);
        combo.setSelection(index);
        String comboText = combo.getText();
        String expectedComboText = COMBO_ITEM_PREFIX + index + index;
        Assert.assertTrue((String)("Combo text is " + comboText + "\nbut expected Combo text is " + expectedComboText), (boolean)comboText.equals(expectedComboText));
    }

    @Test
    public void findByName() {
        int index = 3;
        LabeledCombo combo = new LabeledCombo(COMBO_LABEL_PREFIX + index);
        combo.setSelection(index);
        String comboText = combo.getText();
        String expectedComboText = COMBO_ITEM_PREFIX + index + index;
        Assert.assertTrue((String)("Combo text is " + comboText + "\nbut expected Combo text is " + expectedComboText), (boolean)comboText.equals(expectedComboText));
    }

    @Test
    public void findById() {
        int index = 3;
        DefaultCombo combo = new DefaultCombo(new Matcher[]{new WithIdMatcher(COMBO_TEST_KEY, (Object)index)});
        combo.setSelection(index);
        String comboText = combo.getText();
        String expectedComboText = COMBO_ITEM_PREFIX + index + index;
        Assert.assertTrue((String)("Combo text is " + comboText + "\nbut expected Combo text is " + expectedComboText), (boolean)comboText.equals(expectedComboText));
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingByIndex() {
        new DefaultCombo(5, new Matcher[0]);
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingByLabel() {
        new LabeledCombo("NON_EXISTING_LABEL_&*");
    }

    @Test
    public void enabled() {
        DefaultCombo combo = new DefaultCombo(1, new Matcher[0]);
        Assert.assertTrue((String)"Combo is not enabled", (boolean)combo.isEnabled());
        combo = new LabeledCombo(DISABLED_COMBO_LABEL);
        Assert.assertFalse((String)"Combo is enabled", (boolean)combo.isEnabled());
    }

    @Test
    public void selectionByIndex() {
        int comboIndex = 1;
        int itemIndex = 2;
        LabeledCombo combo = new LabeledCombo(COMBO_LABEL_PREFIX + comboIndex);
        combo.setSelection(itemIndex);
        String comboText = combo.getText();
        String expectedComboText = COMBO_ITEM_PREFIX + comboIndex + itemIndex;
        Assert.assertTrue((String)("Combo text is " + comboText + "\nbut expected Combo text is " + expectedComboText), (boolean)comboText.equals(expectedComboText));
        String selectionText = new DefaultText(0, new Matcher[0]).getText();
        String expectedSelection = COMBO_ITEM_PREFIX + comboIndex + itemIndex;
        Assert.assertTrue((String)("Selection text is " + selectionText + "\nbut expected selection text is " + expectedSelection), (boolean)selectionText.equals(expectedSelection));
    }

    @Test
    public void selectionByItem() {
        int comboIndex = 2;
        int itemIndex = 3;
        LabeledCombo combo = new LabeledCombo(COMBO_LABEL_PREFIX + comboIndex);
        combo.setSelection(COMBO_ITEM_PREFIX + comboIndex + itemIndex);
        String comboText = combo.getText();
        String expectedComboText = COMBO_ITEM_PREFIX + comboIndex + itemIndex;
        Assert.assertTrue((String)("Combo text is " + comboText + "\nbut expected Combo text is " + expectedComboText), (boolean)comboText.equals(expectedComboText));
        String selectionText = new DefaultText(0, new Matcher[0]).getText();
        String expectedSelection = COMBO_ITEM_PREFIX + comboIndex + itemIndex;
        Assert.assertTrue((String)("Selection text is " + selectionText + "\nbut expected selection text is " + expectedSelection), (boolean)selectionText.equals(expectedSelection));
    }

    @Test
    public void getAllItems() {
        int comboIndex = 0;
        while (comboIndex < 4) {
            Object[] expectedItems = this.createSampleComboItems(comboIndex);
            Combo[] combos = new Combo[]{new LabeledCombo(COMBO_LABEL_PREFIX + comboIndex), new DefaultCombo(comboIndex, new Matcher[0])};
            int i = 0;
            while (i < combos.length) {
                Object[] items = combos[i].getItems().toArray(new String[combos[i].getItems().size()]);
                Assert.assertTrue((String)("Retrieved items are: " + Arrays.toString(items) + "\nbut expected are: " + Arrays.toString(expectedItems) + "\nItems were retrieved from " + combos[i].getClass()), (boolean)Arrays.equals(expectedItems, items));
                ++i;
            }
            ++comboIndex;
        }
    }
}

