/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.menu;

import java.util.List;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.api.Item;
import org.eclipse.reddeer.swt.api.Menu;
import org.eclipse.reddeer.swt.api.MenuItem;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.impl.menu.ContextMenu;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.swt.test.impl.menu.AbstractMenuTest;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ContextMenuTest
extends AbstractMenuTest {
    @Test
    public void getAllMenuItems() {
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}).select();
        ContextMenu menu = new ContextMenu();
        List items = menu.getItems();
        Assert.assertNotNull((Object)items);
        Assert.assertTrue((items.size() == 6 ? 1 : 0) != 0);
    }

    @Test
    public void getAllMenuItems_viaConstructor() {
        ContextMenu menu = new ContextMenu((Item)new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}));
        List items = menu.getItems();
        Assert.assertNotNull((Object)items);
        Assert.assertTrue((items.size() == 6 ? 1 : 0) != 0);
    }

    @Test
    public void getMenuItemByPath() {
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}).select();
        ContextMenu menu = new ContextMenu();
        menu.getItem(new String[]{"TreeItem1MenuItem1"});
    }

    @Test(expected=CoreLayerException.class)
    public void getMenuItemByPathNonexisting() {
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}).select();
        ContextMenu menu = new ContextMenu();
        menu.getItem(new String[]{"New1"});
    }

    @Test
    public void getMenuItemByMatcher() {
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}).select();
        ContextMenu menu = new ContextMenu();
        menu.getItem(new Matcher[]{new WithMnemonicTextMatcher((Matcher)new RegexMatcher("TreeItem1Menu.*"))});
    }

    @Test(expected=CoreLayerException.class)
    public void getMenuItemByMatcherNonExisting() {
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}).select();
        ContextMenu menu = new ContextMenu();
        menu.getItem(new Matcher[]{new WithMnemonicTextMatcher((Matcher)new RegexMatcher("TreeItem2Menu.*"))});
    }

    @Test
    public void menuItemGetText() {
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}).select();
        ContextMenuItem item = new ContextMenuItem(new String[]{"TreeItem1MenuItem1"});
        Assert.assertEquals((Object)"TreeItem1MenuItem1", (Object)item.getText());
    }

    @Test
    public void menuItemGetMenu() {
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}).select();
        ContextMenuItem item = new ContextMenuItem(new String[]{"TreeItem1MenuItem1"});
        Assert.assertNotNull((Object)item.getParent());
        Menu menu = item.getParent();
        Assert.assertEquals((Object)"TreeItem1MenuItem1", (Object)((MenuItem)menu.getItems().get(0)).getText());
        Assert.assertEquals((Object)"TreeItem1MenuItem2", (Object)((MenuItem)menu.getItems().get(1)).getText());
    }

    @Test
    public void menuItemGetAvailableChildItems() {
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}).select();
        ContextMenuItem item = new ContextMenuItem(new String[]{"TreeItem1MenuItemWithMenu"});
        List avChildItems = item.getAvailableChildItems();
        Assert.assertTrue((avChildItems.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"TreeItem1MenuItemWithMenuEnabledChild", (Object)((MenuItem)avChildItems.get(0)).getText());
        Assert.assertTrue((boolean)((MenuItem)avChildItems.get(0)).isEnabled());
    }

    @Test
    public void menuItemGetAllChildItems() {
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}).select();
        ContextMenuItem item = new ContextMenuItem(new String[]{"TreeItem1MenuItemWithMenu"});
        List childItems = item.getChildItems();
        Assert.assertTrue((childItems.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"TreeItem1MenuItemWithMenuEnabledChild", (Object)((MenuItem)childItems.get(0)).getText());
        Assert.assertEquals((Object)"TreeItem1MenuItemWithMenuDisabledChild", (Object)((MenuItem)childItems.get(1)).getText());
        Assert.assertTrue((boolean)((MenuItem)childItems.get(0)).isEnabled());
        Assert.assertFalse((boolean)((MenuItem)childItems.get(1)).isEnabled());
    }

    @Test
    public void menuItemConstructor() {
        ContextMenuItem item = new ContextMenuItem((Item)new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}), new String[]{"TreeItem1MenuItemWithMenu"});
        Assert.assertEquals((Object)"TreeItem1MenuItemWithMenu", (Object)item.getText());
    }

    @Test
    public void menuItemConstructor1() {
        ContextMenuItem item = new ContextMenuItem((Item)new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}), new String[]{"TreeItem1MenuItemWithMenu", "TreeItem1MenuItemWithMenuEnabledChild"});
        Assert.assertEquals((Object)"TreeItem1MenuItemWithMenuEnabledChild", (Object)item.getText());
    }

    @Test
    public void disabledMenu() {
        Menu menu = new ContextMenuItem((Item)new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}), new String[]{"DisabledMenu"}).getMenu();
        Assert.assertFalse((boolean)menu.isEnabled());
        Assert.assertTrue((boolean)menu.getParentMenu().isEnabled());
    }

    @Test
    public void selectMenuItem() {
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}).select();
        ContextMenuItem item = new ContextMenuItem(new String[]{"TreeItem1MenuItem1"});
        item.select();
        Assert.assertEquals((Object)("selected " + item.getText()), (Object)new DefaultText().getText());
    }

    @Test
    public void checkMenuItem() {
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}).select();
        ContextMenuItem item = new ContextMenuItem(new String[]{"TreeItem1MenuItemCheck"});
        Assert.assertFalse((boolean)item.isSelected());
        item.select();
        Assert.assertTrue((boolean)item.isSelected());
    }

    @Test
    public void radioMenuItem() {
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this.shell), new String[]{"TreeItem1"}).select();
        ContextMenuItem item = new ContextMenuItem(new String[]{"TreeItem1MenuItemRadio"});
        Assert.assertFalse((boolean)item.isSelected());
        item.select();
        Assert.assertTrue((boolean)item.isSelected());
    }

    @Test
    public void shellContextMenu() {
        new ContextMenuItem((Control)this.shell, new String[]{"ShellContextMenuItem"});
    }

    @Test
    public void hasExistingMenuItem() {
        ContextMenu menu = new ContextMenu((Control)this.shell);
        Assert.assertTrue((boolean)menu.hasItem(new String[]{"ShellContextMenuItem"}));
    }

    @Test
    public void hasNonExistingMenuItem() {
        ContextMenu menu = new ContextMenu((Control)this.shell);
        Assert.assertFalse((boolean)menu.hasItem(new String[]{"ShellContextMenuItemX"}));
    }
}

