/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.codegen.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.codegen.CodeGen;
import org.eclipse.reddeer.codegen.builder.MethodBuilder;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.ButtonRule;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class ButtonCodeGenRule
extends ButtonRule
implements CodeGen {
    private String suffix;

    public boolean appliesTo(Event event) {
        event.type = 13;
        return super.appliesTo(event);
    }

    @Override
    public MethodBuilder constructor(Control control) {
        String label = this.getText();
        label = label == null || label.isEmpty() ? String.valueOf(this.getIndex()) : "\"" + label + "\"";
        String type = this.getType();
        String ref = RedDeerUtils.getReferencedCompositeString((List)this.getComposites());
        if (!ref.isEmpty()) {
            this.suffix = String.valueOf(this.suffix) + "group";
        }
        return MethodBuilder.method().returnType(type).get(String.valueOf(label) + this.suffix).returnCommand("new " + type + "(" + ref + WidgetUtils.cleanText((String)label) + ")").type("Getter").rule(this.suffix);
    }

    public MethodBuilder action(Control control) {
        String label = this.getText();
        label = label == null || label.isEmpty() ? String.valueOf(this.getIndex()) : "\"" + label + "\"";
        String comm = this.getCommand("btn");
        String actionText = comm.substring(comm.lastIndexOf("."), comm.lastIndexOf("("));
        String ref = RedDeerUtils.getReferencedCompositeString((List)this.getComposites());
        if (!ref.isEmpty()) {
            this.suffix = "Group";
        }
        if (actionText.equals(".toggle")) {
            return MethodBuilder.method().name(String.valueOf(actionText) + " " + WidgetUtils.cleanText((String)label) + this.suffix).parameter("boolean choice").command(comm).type("Action method");
        }
        return MethodBuilder.method().name(String.valueOf(actionText) + " " + WidgetUtils.cleanText((String)label) + this.suffix).command(comm).type("Action method").rule(this.suffix);
    }

    public MethodBuilder isChecked(Control control) {
        String label = this.getText();
        label = label == null || label.isEmpty() ? String.valueOf(this.getIndex()) : "\"" + label + "\"";
        String ref = RedDeerUtils.getReferencedCompositeString((List)this.getComposites());
        if (!ref.isEmpty()) {
            this.suffix = "Group";
        }
        return MethodBuilder.method().returnType("boolean").name("isChecked " + WidgetUtils.cleanText((String)label) + this.suffix).returnCommand(this.getCommand("check")).type("Action method").rule(this.suffix);
    }

    public MethodBuilder isSelected(Control control) {
        String label = this.getText();
        label = label == null || label.isEmpty() ? String.valueOf(this.getIndex()) : "\"" + label + "\"";
        String ref = RedDeerUtils.getReferencedCompositeString((List)this.getComposites());
        if (!ref.isEmpty()) {
            this.suffix = "Group";
        }
        return MethodBuilder.method().returnType("boolean").name("isSelected " + WidgetUtils.cleanText((String)label) + this.suffix).returnCommand(this.getCommand("select")).type("Action method").rule(this.suffix);
    }

    @Override
    public MethodBuilder get(Control control) {
        String label = this.getText();
        label = label == null || label.isEmpty() ? String.valueOf(this.getIndex()) : "\"" + label + "\"";
        return MethodBuilder.method().returnType("String").get("Text " + label).returnCommand(this.getCommand("get")).type("Getter").rule(this.suffix);
    }

    @Override
    public List<MethodBuilder> getActionMethods(Control control) {
        ArrayList<MethodBuilder> forReturn = new ArrayList<MethodBuilder>();
        forReturn.add(this.constructor(control));
        forReturn.add(this.get(control));
        forReturn.add(this.action(control));
        switch (this.getType()) {
            case "CheckBox": {
                forReturn.add(this.isChecked(control));
                break;
            }
            case "RadioButton": {
                forReturn.add(this.isSelected(control));
                break;
            }
        }
        return forReturn;
    }

    public String getType() {
        String type = null;
        int style = this.getStyle();
        if ((style & 8) != 0) {
            type = "PushButton";
            this.suffix = "BTN";
        } else if ((style & 0x20) != 0) {
            type = "CheckBox";
            this.suffix = "CHB";
        } else if ((style & 4) != 0) {
            type = "ArrowButton";
            this.suffix = "ARR";
        } else if ((style & 0x10) != 0) {
            type = "RadioButton";
            this.suffix = "RDB";
        } else if ((style & 2) != 0) {
            type = "ToggleButton";
            this.suffix = "TGB";
        }
        if (type == null) {
            throw new IllegalArgumentException("Unsupported button style " + style);
        }
        return type;
    }

    public String getCommand(String type) {
        StringBuilder builder = new StringBuilder("new " + this.getType() + "(");
        builder.append(RedDeerUtils.getReferencedCompositeString((List)this.getComposites()));
        String text = this.getText();
        int index = this.getIndex();
        if (text == null || text.isEmpty()) {
            builder.append(index);
        } else {
            builder.append("\"" + WidgetUtils.cleanText((String)text) + "\"");
        }
        builder.append(")");
        if (type.equals("btn")) {
            if ((this.getStyle() & 0x20) != 0 || (this.getStyle() & 0x10) != 0) {
                builder.append(".toggle(choice)");
            } else {
                builder.append(".click()");
            }
        } else if (type.equals("get")) {
            builder.append(".getText()");
        } else if (type.equals("check")) {
            builder.append(".isChecked()");
        } else if (type.equals("select")) {
            builder.append(".isSelected()");
        }
        return builder.toString();
    }
}

