/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.codegen.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.codegen.CodeGen;
import org.eclipse.reddeer.codegen.builder.MethodBuilder;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.TextRule;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class TextCodeGenRule
extends TextRule
implements CodeGen {
    public boolean appliesTo(Event event) {
        event.type = 24;
        if (event.widget instanceof Text) {
            try {
                return !WidgetUtils.cleanText((String)WidgetUtils.getLabel((Control)((Text)event.widget))).isEmpty();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    public MethodBuilder constructor(Control control) {
        String type = "LabeledText";
        String label = this.getLabel();
        if (label == null || label.isEmpty()) {
            type = "DefaultText";
            label = String.valueOf(this.getIndex());
        } else {
            label = "\"" + label + "\"";
        }
        String ref = RedDeerUtils.getReferencedCompositeString((List)RedDeerUtils.getComposites((Control)control));
        return MethodBuilder.method().returnType(type).get(String.valueOf(label) + "TXT").returnCommand("new " + type + "(" + ref + WidgetUtils.cleanText((String)label) + ")").type("Getter").rule("TXT");
    }

    public MethodBuilder set(Control control) {
        String label = this.getLabel();
        label = label == null || label.isEmpty() ? String.valueOf(this.getIndex()) : "\"" + label + "\"";
        return MethodBuilder.method().name("setText " + label).parameter("String str").command(this.getCommand("set")).type("Setter").rule("TXT");
    }

    @Override
    public MethodBuilder get(Control control) {
        String label = this.getLabel();
        label = label == null || label.isEmpty() ? String.valueOf(this.getIndex()) : "\"" + label + "\"";
        return MethodBuilder.method().returnType("String").get("Text " + label).returnCommand(this.getCommand("get")).type("Getter").rule("TXT");
    }

    @Override
    public List<MethodBuilder> getActionMethods(Control control) {
        ArrayList<MethodBuilder> forReturn = new ArrayList<MethodBuilder>();
        forReturn.add(this.constructor(control));
        forReturn.add(this.set(control));
        forReturn.add(this.get(control));
        return forReturn;
    }

    public String getCommand(String type) {
        StringBuffer sb = new StringBuffer();
        String label = this.getLabel();
        if (label != null) {
            sb.append("new LabeledText(");
            sb.append(RedDeerUtils.getReferencedCompositeString((List)this.getComposites()));
            sb.append("\"" + WidgetUtils.cleanText((String)label) + "\"");
        } else {
            sb.append("new DefaultText(");
            sb.append(RedDeerUtils.getReferencedCompositeString((List)this.getComposites()));
            sb.append(this.getIndex());
        }
        if (type.equals("set")) {
            sb.append(").setText(str)");
        } else if (type.equals("get")) {
            sb.append(").getText()");
        }
        return sb.toString();
    }
}

