/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.test.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.reddeer.common.util.XPathEvaluator;
import org.junit.Assert;
import org.junit.Test;

public class XPathEvaluatorTest {
    @Test
    public void testXPathWithoutNamespaces() throws Exception {
        String xml = "<a><b c='123'></b></a>";
        XPathEvaluator xpath = new XPathEvaluator((InputStream)new ByteArrayInputStream(xml.getBytes()), true);
        Assert.assertEquals((Object)"123", (Object)xpath.evaluateXPath("/a/b/@c"));
    }

    @Test
    public void testXPathWithNamespaces() throws Exception {
        String xml = "<x:a xmlns:x='http://localhost/x' xmlns:y='http://localhost/y'><y:b c='123' ></y:b></x:a>";
        XPathEvaluator xpath = new XPathEvaluator((InputStream)new ByteArrayInputStream(xml.getBytes()), true);
        Assert.assertEquals((Object)"123", (Object)xpath.evaluateXPath("/x:a/y:b/@c"));
    }

    @Test
    public void testXPathWithAndWithoutNamespaces() throws Exception {
        String xml = "<a xmlns:y='http://localhost/y'><y:b c='123' ></y:b></a>";
        XPathEvaluator xpath = new XPathEvaluator((InputStream)new ByteArrayInputStream(xml.getBytes()), true);
        Assert.assertEquals((Object)"123", (Object)xpath.evaluateXPath("/a/y:b/@c"));
    }

    @Test
    public void testXPathWithUserDefinedNamespaces() throws Exception {
        String xml = "<x:a xmlns:x='http://localhost/x' xmlns:y='http://localhost/y'><y:b c='123' ></y:b></x:a>";
        XPathEvaluator xpath = new XPathEvaluator((InputStream)new ByteArrayInputStream(xml.getBytes()), true);
        xpath.setNamespace("foo", "http://localhost/x");
        Assert.assertEquals((Object)"123", (Object)xpath.evaluateXPath("/foo:a/y:b/@c"));
    }

    @Test
    public void testXPathWithoutNamespacesAndIgnoringNamespaces() throws Exception {
        String xml = "<a><b c='123'></b></a>";
        XPathEvaluator xpath = new XPathEvaluator((InputStream)new ByteArrayInputStream(xml.getBytes()), false);
        Assert.assertEquals((Object)"123", (Object)xpath.evaluateXPath("/a/b/@c"));
    }

    @Test
    public void testXPathWithNamespacesAndIgnoringNamespaces() throws Exception {
        String xml = "<x:a xmlns:x='http://localhost/x' xmlns:y='http://localhost/y'><y:b c='123' ></y:b></x:a>";
        XPathEvaluator xpath = new XPathEvaluator((InputStream)new ByteArrayInputStream(xml.getBytes()), false);
        Assert.assertEquals((Object)"123", (Object)xpath.evaluateXPath("/a/b/@c"));
    }
}

