/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.test.wait;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.test.wait.CustomWaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WaitUntilTest {
    private WaitCondition falseCondition;

    @Before
    public void setupCondition() {
        this.falseCondition = new CustomWaitCondition(false, 5, () -> CustomWaitCondition.sleep(1000L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NullCondition() {
        new WaitUntil(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NullTimePeriod() {
        new WaitUntil(this.falseCondition, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_IllegalTimePeriod() {
        new WaitUntil(this.falseCondition, TimePeriod.getCustom((long)-1L));
    }

    @Test(expected=WaitTimeoutExpiredException.class)
    public void test_ThrowingException() {
        new WaitUntil(this.falseCondition, TimePeriod.SHORT);
    }

    @Test
    public void test_NotThrowingException() {
        try {
            new WaitUntil(this.falseCondition, TimePeriod.MEDIUM, false);
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.fail((String)"WaitTimeoutExpiredException should not be thrown");
        }
    }

    @Test
    public void test_WaitUntilFulFilled() {
        try {
            new WaitUntil(this.falseCondition, TimePeriod.DEFAULT);
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.fail((String)"WaitTimeoutExpiredException should not be thrown");
        }
    }
}

