/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.debug.ui.launchConfigurations;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.LaunchConfiguration;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public abstract class AbstractLaunchConfigurationDialogTest {
    protected LaunchConfigurationsDialog dialog;

    protected abstract String getConfigurationName();

    @After
    public void closeDialog() {
        try {
            new WaitUntil((WaitCondition)new ShellIsAvailable(this.dialog.getTitle()), TimePeriod.NONE);
            new DefaultShell(this.dialog.getTitle()).close();
        }
        catch (RedDeerException redDeerException) {}
    }

    @Test
    public void createSelectDelete() {
        JUnitConfiguration configuration = new JUnitConfiguration();
        this.dialog.open();
        this.dialog.create((LaunchConfiguration)configuration);
        this.dialog.create((LaunchConfiguration)configuration, this.getConfigurationName());
        this.dialog.select((LaunchConfiguration)configuration);
        Assert.assertTrue((boolean)new DefaultTreeItem(new String[]{configuration.getType()}).isSelected());
        this.dialog.select((LaunchConfiguration)configuration, this.getConfigurationName());
        Assert.assertTrue((boolean)new DefaultTreeItem(new String[]{configuration.getType(), this.getConfigurationName()}).isSelected());
        this.dialog.delete((LaunchConfiguration)configuration, this.getConfigurationName());
        try {
            new DefaultTreeItem(new String[]{configuration.getType(), this.getConfigurationName()});
            Assert.fail((String)"The configuration shoud have been deleted");
        }
        catch (RedDeerException redDeerException) {}
    }

    private class JUnitConfiguration
    extends LaunchConfiguration {
        public JUnitConfiguration() {
            super("JUnit");
        }
    }
}

