/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.rse.ui.view;

import java.util.List;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.eclipse.rse.ui.view.System;
import org.eclipse.reddeer.eclipse.rse.ui.wizards.newconnection.RSENewConnectionWizardSelectionPage;
import org.eclipse.reddeer.eclipse.test.rse.ui.view.SystemViewTestCase;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public class SystemTest
extends SystemViewTestCase {
    private static final String SYSTEM_1 = "system1";
    private static final String SYSTEM_2 = "system2";
    private System system1;

    @Before
    public void setUp() {
        this.createSystem("127.0.0.1", SYSTEM_1, RSENewConnectionWizardSelectionPage.SystemType.SSH_ONLY);
        this.createSystem("localhost", SYSTEM_2, RSENewConnectionWizardSelectionPage.SystemType.SSH_ONLY);
        this.remoteSystemView.open();
        this.system1 = this.remoteSystemView.getSystem(SYSTEM_1);
    }

    @Test(expected=CoreLayerException.class)
    public void disconnect_disconnected() {
        this.system1.disconnect();
    }

    @Test
    public void isConnected_false() {
        Assert.assertFalse((boolean)this.system1.isConnected());
    }

    @Test
    public void delete() {
        List systems = this.remoteSystemView.getSystems();
        Assert.assertThat((Object)systems.size(), (Matcher)CoreMatchers.is((Object)3));
        this.system1.delete();
        systems = this.remoteSystemView.getSystems();
        Assert.assertThat((Object)systems.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((System)systems.get(1)).getLabel(), (Matcher)CoreMatchers.is((Object)SYSTEM_2));
    }
}

